/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.rankingexpression;

import ai.vespa.schemals.parser.rankingexpression.InvalidToken;
import ai.vespa.schemals.parser.rankingexpression.Token;
import ai.vespa.schemals.parser.rankingexpression.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;

public class RankingExpressionParserLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = null;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public static EnumSet<Token.TokenType> getRegularTokens() {
        return EnumSet.copyOf(regularTokens);
    }

    public RankingExpressionParserLexer(CharSequence input) {
        this("input", input);
    }

    public RankingExpressionParserLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public RankingExpressionParserLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(417);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(417);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(417);
        BitSet nextStates = new BitSet(417);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = RankingExpressionParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = RankingExpressionParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.LBRACE, Token.TokenType.RBRACE, Token.TokenType.LSQUARE, Token.TokenType.RSQUARE, Token.TokenType.LCURLY, Token.TokenType.RCURLY, Token.TokenType.ADD, Token.TokenType.SUB, Token.TokenType.DIV, Token.TokenType.MUL, Token.TokenType.DOT, Token.TokenType.MOD, Token.TokenType.POWOP, Token.TokenType.DOLLAR, Token.TokenType.COMMA, Token.TokenType.COLON, Token.TokenType.GREATEREQUAL, Token.TokenType.GREATER, Token.TokenType.LESSEQUAL, Token.TokenType.LESS, Token.TokenType.APPROX, Token.TokenType.NOTEQUAL, Token.TokenType.EQUAL, Token.TokenType.IF, Token.TokenType.IN, Token.TokenType.F, Token.TokenType.NOT, Token.TokenType.AND, Token.TokenType.OR, Token.TokenType.ABS, Token.TokenType.ACOS, Token.TokenType.ASIN, Token.TokenType.ATAN, Token.TokenType.CEIL, Token.TokenType.COS, Token.TokenType.COSH, Token.TokenType.ELU, Token.TokenType.EXP, Token.TokenType.FABS, Token.TokenType.FLOOR, Token.TokenType.ISNAN, Token.TokenType.LOG, Token.TokenType.LOG10, Token.TokenType.RELU, Token.TokenType.ROUND, Token.TokenType.SIGMOID, Token.TokenType.SIGN, Token.TokenType.SIN, Token.TokenType.SINH, Token.TokenType.SQUARE, Token.TokenType.SQRT, Token.TokenType.TAN, Token.TokenType.TANH, Token.TokenType.ERF, Token.TokenType.ATAN2, Token.TokenType.FMOD, Token.TokenType.LDEXP, Token.TokenType.POW, Token.TokenType.BIT, Token.TokenType.HAMMING, Token.TokenType.MAP, Token.TokenType.MAP_SUBSPACES, Token.TokenType.UNPACK_BITS, Token.TokenType.REDUCE, Token.TokenType.JOIN, Token.TokenType.MERGE, Token.TokenType.RENAME, Token.TokenType.CONCAT, Token.TokenType.TENSOR, Token.TokenType.RANGE, Token.TokenType.DIAG, Token.TokenType.RANDOM, Token.TokenType.L1_NORMALIZE, Token.TokenType.L2_NORMALIZE, Token.TokenType.EUCLIDEAN_DISTANCE, Token.TokenType.COSINE_SIMILARITY, Token.TokenType.MATMUL, Token.TokenType.SOFTMAX, Token.TokenType.XW_PLUS_B, Token.TokenType.ARGMAX, Token.TokenType.ARGMIN, Token.TokenType.CELL_CAST, Token.TokenType.EXPAND, Token.TokenType.AVG, Token.TokenType.COUNT, Token.TokenType.MAX, Token.TokenType.MEDIAN, Token.TokenType.MIN, Token.TokenType.PROD, Token.TokenType.SUM, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.INTEGER, Token.TokenType.FLOAT, Token.TokenType.STRING, Token.TokenType.IDENTIFIER});
        unparsedTokens = EnumSet.of(Token.TokenType.SINGLE_LINE_COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType._TOKEN_93);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NOTEQUAL)) {
                    nextStates.set(4);
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(54);
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AND)) {
                    nextStates.set(15);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(21);
                }
            } else if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(160);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LESSEQUAL)) {
                    nextStates.set(34);
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EQUAL)) {
                    nextStates.set(32);
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GREATEREQUAL)) {
                    nextStates.set(65);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AVG)) {
                    nextStates.set(89);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ASIN)) {
                    nextStates.set(90);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ARGMIN)) {
                    nextStates.set(118);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ABS)) {
                    nextStates.set(130);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ATAN2)) {
                    nextStates.set(157);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ATAN)) {
                    nextStates.set(161);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ACOS)) {
                    nextStates.set(299);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ARGMAX)) {
                    nextStates.set(301);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BIT)) {
                    nextStates.set(145);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COS)) {
                    nextStates.set(87);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONCAT)) {
                    nextStates.set(101);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CEIL)) {
                    nextStates.set(143);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.COSH)) {
                    nextStates.set(168);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CELL_CAST)) {
                    nextStates.set(179);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.COSINE_SIMILARITY)) {
                    nextStates.set(208);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.COUNT)) {
                    nextStates.set(237);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DIAG)) {
                    nextStates.set(244);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXP)) {
                    nextStates.set(92);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ERF)) {
                    nextStates.set(186);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ELU)) {
                    nextStates.set(232);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXPAND)) {
                    nextStates.set(240);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EUCLIDEAN_DISTANCE)) {
                    nextStates.set(259);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOOR)) {
                    nextStates.set(125);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FMOD)) {
                    nextStates.set(176);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FABS)) {
                    nextStates.set(187);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(305);
                }
            } else if (ch == 104) {
                if (validTypes == null || validTypes.contains(Token.TokenType.HAMMING)) {
                    nextStates.set(277);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ISNAN)) {
                    nextStates.set(122);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IN)) {
                    nextStates.set(23);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IF)) {
                    nextStates.set(75);
                }
            } else if (ch == 106) {
                if (validTypes == null || validTypes.contains(Token.TokenType.JOIN)) {
                    nextStates.set(282);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LOG)) {
                    nextStates.set(86);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LOG10)) {
                    nextStates.set(133);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.L2_NORMALIZE)) {
                    nextStates.set(146);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LDEXP)) {
                    nextStates.set(200);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.L1_NORMALIZE)) {
                    nextStates.set(249);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MAP)) {
                    nextStates.set(88);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAP_SUBSPACES)) {
                    nextStates.set(107);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MIN)) {
                    nextStates.set(142);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MERGE)) {
                    nextStates.set(229);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MEDIAN)) {
                    nextStates.set(233);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX)) {
                    nextStates.set(248);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MATMUL)) {
                    nextStates.set(284);
                }
            } else if (ch == 112) {
                if (validTypes == null || validTypes.contains(Token.TokenType.POW)) {
                    nextStates.set(156);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PROD)) {
                    nextStates.set(174);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RENAME)) {
                    nextStates.set(97);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RELU)) {
                    nextStates.set(128);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ROUND)) {
                    nextStates.set(136);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANGE)) {
                    nextStates.set(139);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANDOM)) {
                    nextStates.set(170);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.REDUCE)) {
                    nextStates.set(223);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SQUARE)) {
                    nextStates.set(93);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SIN)) {
                    nextStates.set(132);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SIGMOID)) {
                    nextStates.set(163);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUM)) {
                    nextStates.set(178);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SOFTMAX)) {
                    nextStates.set(203);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SIGN)) {
                    nextStates.set(227);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SQRT)) {
                    nextStates.set(246);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SINH)) {
                    nextStates.set(275);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(105);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TAN)) {
                    nextStates.set(190);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TENSOR)) {
                    nextStates.set(288);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TANH)) {
                    nextStates.set(308);
                }
            } else if (ch == 117) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNPACK_BITS)) {
                    nextStates.set(191);
                }
            } else if (ch == 120) {
                if (validTypes == null || validTypes.contains(Token.TokenType.XW_PLUS_B)) {
                    nextStates.set(292);
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OR)) {
                    nextStates.set(39);
                }
            } else if (ch == 126) {
                if (validTypes == null || validTypes.contains(Token.TokenType.APPROX)) {
                    nextStates.set(9);
                }
            } else if (ch == 35 && (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT))) {
                nextStates.set(57);
                type = Token.TokenType.SINGLE_LINE_COMMENT;
            }
            if ((ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) && (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER))) {
                nextStates.set(27);
                type = Token.TokenType.IDENTIFIER;
            }
            if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.FLOAT))) {
                nextStates.set(42);
                type = Token.TokenType.FLOAT;
            }
            if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(5);
                    type = Token.TokenType.INTEGER;
                }
            } else if (ch >= 49 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(70);
                    type = Token.TokenType.INTEGER;
                }
            } else if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_93)) {
                    type = Token.TokenType._TOKEN_93;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NOT)) {
                    type = Token.TokenType.NOT;
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.F)) {
                    type = Token.TokenType.F;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS)) {
                    type = Token.TokenType.LESS;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GREATER)) {
                    type = Token.TokenType.GREATER;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOLLAR)) {
                    type = Token.TokenType.DOLLAR;
                }
            } else if (ch == 94) {
                if (validTypes == null || validTypes.contains(Token.TokenType.POWOP)) {
                    type = Token.TokenType.POWOP;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MOD)) {
                    type = Token.TokenType.MOD;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MUL)) {
                    type = Token.TokenType.MUL;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DIV)) {
                    type = Token.TokenType.DIV;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SUB)) {
                    type = Token.TokenType.SUB;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ADD)) {
                    type = Token.TokenType.ADD;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RCURLY)) {
                    type = Token.TokenType.RCURLY;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LCURLY)) {
                    type = Token.TokenType.LCURLY;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RSQUARE)) {
                    type = Token.TokenType.RSQUARE;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LSQUARE)) {
                    type = Token.TokenType.LSQUARE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACE)) {
                    type = Token.TokenType.RBRACE;
                }
            } else if (ch == 40 && (validTypes == null || validTypes.contains(Token.TokenType.LBRACE))) {
                type = Token.TokenType.LBRACE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.LOG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.COS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.MAP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.NOTEQUAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 55) {
                nextStates.set(5);
                type = Token.TokenType.INTEGER;
            } else if (ch == 76 || ch == 108) {
                type = Token.TokenType.INTEGER;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.AVG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ASIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.EXP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.APPROX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SQUARE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.RENAME;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CONCAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MAP_SUBSPACES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 38) {
                return Token.TokenType.AND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ARGMIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ISNAN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.FLOOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                return Token.TokenType.RELU;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.ABS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(21);
            }
            if (ch == 92) {
                nextStates.set(131);
            } else if (ch == 39) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.SIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.IN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 48) {
                return Token.TokenType.LOG10;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.ROUND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.RANGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 36 || ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(27);
                return Token.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.MIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.CEIL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.BIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.L2_NORMALIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.EQUAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return Token.TokenType.POW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.LESSEQUAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 50) {
                return Token.TokenType.ATAN2;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(37);
                return Token.TokenType.INTEGER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(37);
                type = Token.TokenType.INTEGER;
            } else if (ch == 76 || ch == 108) {
                type = Token.TokenType.INTEGER;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ATAN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 124) {
                return Token.TokenType.OR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.SIGMOID;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.COSH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(44);
            } else if (ch == 46) {
                nextStates.set(43);
                type = Token.TokenType.FLOAT;
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                type = Token.TokenType.FLOAT;
            } else if (ch == 68 || ch == 70 || ch == 100 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(44);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(43);
                type = Token.TokenType.FLOAT;
            } else if (ch == 68 || ch == 70 || ch == 100 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(46);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(45);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(45);
                type = Token.TokenType.FLOAT;
            } else if (ch == 68 || ch == 70 || ch == 100 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(45);
                return Token.TokenType.FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.RANDOM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.PROD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.FMOD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.SUM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CELL_CAST;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.ERF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.FABS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(54);
            }
            if (ch == 92) {
                nextStates.set(189);
            } else if (ch == 34) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.TAN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.UNPACK_BITS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14) {
                nextStates.set(57);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.LDEXP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.SOFTMAX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.COSINE_SIMILARITY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.REDUCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.SIGN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.MERGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                return Token.TokenType.ELU;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.GREATEREQUAL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.MEDIAN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.COUNT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.EXPAND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.DIAG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(70);
                type = Token.TokenType.INTEGER;
            } else if (ch == 76 || ch == 108) {
                type = Token.TokenType.INTEGER;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.SQRT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.MAX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.L1_NORMALIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.EUCLIDEAN_DISTANCE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.IF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.SINH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.HAMMING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.JOIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.MATMUL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.TENSOR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                return Token.TokenType.XW_PLUS_B;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.ACOS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.ARGMAX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.TANH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(91);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(7);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 113) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(95);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(96);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(100);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(12);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(106);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(13);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(109);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(110);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(111);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(113);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(119);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(121);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(123);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 78) {
                nextStates.set(124);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(126);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(127);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(129);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(19);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 39) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(22);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(134);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(135);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 49) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(137);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(140);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(141);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(28);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(29);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 50) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(148);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(151);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(153);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(154);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(158);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(35);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(36);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(162);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(164);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(165);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(166);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(40);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(171);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(175);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(177);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(50);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(180);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(182);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(183);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(185);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(188);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(54);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(192);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(193);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(194);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(195);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(196);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(197);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(198);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(199);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(201);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(202);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(204);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(205);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(206);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(207);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(59);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(209);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(210);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(211);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(212);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(213);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(214);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(215);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(216);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(217);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(218);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(219);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(220);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(221);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(222);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(224);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(225);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(226);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(228);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(62);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(230);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(231);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(234);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(235);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(236);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(66);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(238);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(239);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(67);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(241);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(242);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(243);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(245);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(69);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 113) {
                nextStates.set(247);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(71);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 49) {
                nextStates.set(250);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(251);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(252);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(253);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(254);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(255);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(256);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(257);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(258);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(260);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(261);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(262);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(263);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(264);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(265);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(266);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(267);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(268);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(269);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(270);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(271);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(272);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(273);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(274);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(276);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(278);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(279);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(280);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(281);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(283);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(78);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(285);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(286);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(287);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(79);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(289);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(290);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(291);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(293);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(294);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(295);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(296);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(297);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(298);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(300);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(82);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(302);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(303);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(304);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(83);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(306);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(307);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(84);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(309);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(85);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103, DEFAULT::getNfaIndex104, DEFAULT::getNfaIndex105, DEFAULT::getNfaIndex106, DEFAULT::getNfaIndex107, DEFAULT::getNfaIndex108, DEFAULT::getNfaIndex109, DEFAULT::getNfaIndex110, DEFAULT::getNfaIndex111, DEFAULT::getNfaIndex112, DEFAULT::getNfaIndex113, DEFAULT::getNfaIndex114, DEFAULT::getNfaIndex115, DEFAULT::getNfaIndex116, DEFAULT::getNfaIndex117, DEFAULT::getNfaIndex118, DEFAULT::getNfaIndex119, DEFAULT::getNfaIndex120, DEFAULT::getNfaIndex121, DEFAULT::getNfaIndex122, DEFAULT::getNfaIndex123, DEFAULT::getNfaIndex124, DEFAULT::getNfaIndex125, DEFAULT::getNfaIndex126, DEFAULT::getNfaIndex127, DEFAULT::getNfaIndex128, DEFAULT::getNfaIndex129, DEFAULT::getNfaIndex130, DEFAULT::getNfaIndex131, DEFAULT::getNfaIndex132, DEFAULT::getNfaIndex133, DEFAULT::getNfaIndex134, DEFAULT::getNfaIndex135, DEFAULT::getNfaIndex136, DEFAULT::getNfaIndex137, DEFAULT::getNfaIndex138, DEFAULT::getNfaIndex139, DEFAULT::getNfaIndex140, DEFAULT::getNfaIndex141, DEFAULT::getNfaIndex142, DEFAULT::getNfaIndex143, DEFAULT::getNfaIndex144, DEFAULT::getNfaIndex145, DEFAULT::getNfaIndex146, DEFAULT::getNfaIndex147, DEFAULT::getNfaIndex148, DEFAULT::getNfaIndex149, DEFAULT::getNfaIndex150, DEFAULT::getNfaIndex151, DEFAULT::getNfaIndex152, DEFAULT::getNfaIndex153, DEFAULT::getNfaIndex154, DEFAULT::getNfaIndex155, DEFAULT::getNfaIndex156, DEFAULT::getNfaIndex157, DEFAULT::getNfaIndex158, DEFAULT::getNfaIndex159, DEFAULT::getNfaIndex160, DEFAULT::getNfaIndex161, DEFAULT::getNfaIndex162, DEFAULT::getNfaIndex163, DEFAULT::getNfaIndex164, DEFAULT::getNfaIndex165, DEFAULT::getNfaIndex166, DEFAULT::getNfaIndex167, DEFAULT::getNfaIndex168, DEFAULT::getNfaIndex169, DEFAULT::getNfaIndex170, DEFAULT::getNfaIndex171, DEFAULT::getNfaIndex172, DEFAULT::getNfaIndex173, DEFAULT::getNfaIndex174, DEFAULT::getNfaIndex175, DEFAULT::getNfaIndex176, DEFAULT::getNfaIndex177, DEFAULT::getNfaIndex178, DEFAULT::getNfaIndex179, DEFAULT::getNfaIndex180, DEFAULT::getNfaIndex181, DEFAULT::getNfaIndex182, DEFAULT::getNfaIndex183, DEFAULT::getNfaIndex184, DEFAULT::getNfaIndex185, DEFAULT::getNfaIndex186, DEFAULT::getNfaIndex187, DEFAULT::getNfaIndex188, DEFAULT::getNfaIndex189, DEFAULT::getNfaIndex190, DEFAULT::getNfaIndex191, DEFAULT::getNfaIndex192, DEFAULT::getNfaIndex193, DEFAULT::getNfaIndex194, DEFAULT::getNfaIndex195, DEFAULT::getNfaIndex196, DEFAULT::getNfaIndex197, DEFAULT::getNfaIndex198, DEFAULT::getNfaIndex199, DEFAULT::getNfaIndex200, DEFAULT::getNfaIndex201, DEFAULT::getNfaIndex202, DEFAULT::getNfaIndex203, DEFAULT::getNfaIndex204, DEFAULT::getNfaIndex205, DEFAULT::getNfaIndex206, DEFAULT::getNfaIndex207, DEFAULT::getNfaIndex208, DEFAULT::getNfaIndex209, DEFAULT::getNfaIndex210, DEFAULT::getNfaIndex211, DEFAULT::getNfaIndex212, DEFAULT::getNfaIndex213, DEFAULT::getNfaIndex214, DEFAULT::getNfaIndex215, DEFAULT::getNfaIndex216, DEFAULT::getNfaIndex217, DEFAULT::getNfaIndex218, DEFAULT::getNfaIndex219, DEFAULT::getNfaIndex220, DEFAULT::getNfaIndex221, DEFAULT::getNfaIndex222, DEFAULT::getNfaIndex223, DEFAULT::getNfaIndex224, DEFAULT::getNfaIndex225, DEFAULT::getNfaIndex226, DEFAULT::getNfaIndex227, DEFAULT::getNfaIndex228, DEFAULT::getNfaIndex229, DEFAULT::getNfaIndex230, DEFAULT::getNfaIndex231, DEFAULT::getNfaIndex232, DEFAULT::getNfaIndex233, DEFAULT::getNfaIndex234, DEFAULT::getNfaIndex235, DEFAULT::getNfaIndex236, DEFAULT::getNfaIndex237, DEFAULT::getNfaIndex238, DEFAULT::getNfaIndex239, DEFAULT::getNfaIndex240, DEFAULT::getNfaIndex241, DEFAULT::getNfaIndex242, DEFAULT::getNfaIndex243, DEFAULT::getNfaIndex244, DEFAULT::getNfaIndex245, DEFAULT::getNfaIndex246, DEFAULT::getNfaIndex247, DEFAULT::getNfaIndex248, DEFAULT::getNfaIndex249, DEFAULT::getNfaIndex250, DEFAULT::getNfaIndex251, DEFAULT::getNfaIndex252, DEFAULT::getNfaIndex253, DEFAULT::getNfaIndex254, DEFAULT::getNfaIndex255, DEFAULT::getNfaIndex256, DEFAULT::getNfaIndex257, DEFAULT::getNfaIndex258, DEFAULT::getNfaIndex259, DEFAULT::getNfaIndex260, DEFAULT::getNfaIndex261, DEFAULT::getNfaIndex262, DEFAULT::getNfaIndex263, DEFAULT::getNfaIndex264, DEFAULT::getNfaIndex265, DEFAULT::getNfaIndex266, DEFAULT::getNfaIndex267, DEFAULT::getNfaIndex268, DEFAULT::getNfaIndex269, DEFAULT::getNfaIndex270, DEFAULT::getNfaIndex271, DEFAULT::getNfaIndex272, DEFAULT::getNfaIndex273, DEFAULT::getNfaIndex274, DEFAULT::getNfaIndex275, DEFAULT::getNfaIndex276, DEFAULT::getNfaIndex277, DEFAULT::getNfaIndex278, DEFAULT::getNfaIndex279, DEFAULT::getNfaIndex280, DEFAULT::getNfaIndex281, DEFAULT::getNfaIndex282, DEFAULT::getNfaIndex283, DEFAULT::getNfaIndex284, DEFAULT::getNfaIndex285, DEFAULT::getNfaIndex286, DEFAULT::getNfaIndex287, DEFAULT::getNfaIndex288, DEFAULT::getNfaIndex289, DEFAULT::getNfaIndex290, DEFAULT::getNfaIndex291, DEFAULT::getNfaIndex292, DEFAULT::getNfaIndex293, DEFAULT::getNfaIndex294, DEFAULT::getNfaIndex295, DEFAULT::getNfaIndex296, DEFAULT::getNfaIndex297, DEFAULT::getNfaIndex298, DEFAULT::getNfaIndex299, DEFAULT::getNfaIndex300, DEFAULT::getNfaIndex301, DEFAULT::getNfaIndex302, DEFAULT::getNfaIndex303, DEFAULT::getNfaIndex304, DEFAULT::getNfaIndex305, DEFAULT::getNfaIndex306, DEFAULT::getNfaIndex307, DEFAULT::getNfaIndex308, DEFAULT::getNfaIndex309};
        }
    }
}

