/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.SymbolArgument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;

public class FieldArgument
extends SymbolArgument {
    public static final EnumSet<FieldType> AnyFieldType = EnumSet.allOf(FieldType.class);
    public static final EnumSet<FieldType> NumericOrTensorFieldType = EnumSet.of(FieldType.TENSOR, FieldType.NUMERIC);
    public static final EnumSet<FieldType> SingleValueOrArrayType = EnumSet.of(FieldType.NUMERIC, FieldType.STRING, FieldType.NUMERIC_ARRAY, FieldType.STRING_ARRAY);
    public static final EnumSet<FieldIndex.IndexingType> IndexAttributeType = EnumSet.of(FieldIndex.IndexingType.ATTRIBUTE, FieldIndex.IndexingType.INDEX);
    private Set<FieldType> fieldTypes;
    private Set<FieldIndex.IndexingType> indexingTypes;

    public FieldArgument(EnumSet<FieldType> fieldTypes, EnumSet<FieldIndex.IndexingType> indexingTypes, String displayStr) {
        super(Symbol.SymbolType.FIELD, displayStr);
        this.fieldTypes = fieldTypes;
        this.indexingTypes = indexingTypes;
    }

    public FieldArgument(EnumSet<FieldType> fieldTypes, EnumSet<FieldIndex.IndexingType> indexingTypes) {
        this(fieldTypes, indexingTypes, "name");
    }

    public FieldArgument(EnumSet<FieldType> fieldTypes) {
        this(fieldTypes, EnumSet.noneOf(FieldIndex.IndexingType.class));
    }

    public FieldArgument(FieldType fieldType) {
        this(EnumSet.of(fieldType));
    }

    public FieldArgument(FieldType fieldType, FieldIndex.IndexingType indexingType) {
        this(EnumSet.of(fieldType), indexingType);
    }

    public FieldArgument(FieldType fieldType, FieldIndex.IndexingType indexingType, String displayStr) {
        this(EnumSet.of(fieldType), indexingType, displayStr);
    }

    public FieldArgument(EnumSet<FieldType> fieldTypes, FieldIndex.IndexingType indexingType) {
        this(fieldTypes, EnumSet.of(indexingType));
    }

    public FieldArgument(EnumSet<FieldType> fieldTypes, FieldIndex.IndexingType indexingType, String displayStr) {
        this(fieldTypes, EnumSet.of(indexingType), displayStr);
    }

    public FieldArgument(FieldType fieldType, EnumSet<FieldIndex.IndexingType> indexingTypes) {
        this(EnumSet.of(fieldType), indexingTypes);
    }

    public FieldArgument(FieldType fieldType, EnumSet<FieldIndex.IndexingType> indexingTypes, String displayStr) {
        this(EnumSet.of(fieldType), indexingTypes, displayStr);
    }

    public FieldArgument() {
        this(AnyFieldType);
    }

    public FieldArgument(String displayStr) {
        this(AnyFieldType, EnumSet.noneOf(FieldIndex.IndexingType.class), displayStr);
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        RankNode featureNode;
        Optional<SchemaNode> firstProperty;
        Optional<Diagnostic> diagnostic = super.parseArgument(context, node);
        if (node.getChildren().size() > 0 && (firstProperty = (featureNode = node.getChildren().get(0)).getProperty()).isPresent()) {
            Node parentNode = firstProperty.get().getParent();
            Optional<Symbol> scope = CSTUtils.findScope(parentNode);
            for (int i = 0; i < parentNode.size(); i += 2) {
                parentNode.get(i).get(0).setSymbol(Symbol.SymbolType.SUBFIELD, context.fileURI(), scope);
            }
        }
        if (diagnostic.isEmpty()) {
            SchemaNode unresolvedFieldArgument = super.findSymbolNode(node);
            context.addUnresolvedFieldArgument(new UnresolvedFieldArgument(unresolvedFieldArgument, this.fieldTypes, this.indexingTypes));
        }
        return diagnostic;
    }

    public record UnresolvedFieldArgument(SchemaNode node, Set<FieldType> fieldTypes, Set<FieldIndex.IndexingType> indexingTypes) {
    }

    public static enum FieldType {
        TENSOR,
        WSET,
        INTEGER,
        NUMERIC,
        NUMERIC_ARRAY,
        STRING,
        STRING_ARRAY,
        POSITION,
        PREDICATE;

    }
}

