/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.completion.provider;

import ai.vespa.schemals.common.StringUtils;
import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.schema.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.schema.completion.utils.CompletionUtils;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class FieldsCompletion
implements CompletionProvider {
    private boolean match(EventCompletionContext context) {
        SchemaNode match = context.document.lexer().matchBackwardsOnLine(context.position, false, Token.TokenType.FIELDS, Token.TokenType.COLON);
        return match != null && match.getRange().getStart().getLine() == context.position.getLine();
    }

    private int previousBeforeDot(String documentContent, Position position) {
        int originalOffset = StringUtils.positionToOffset(documentContent, position);
        for (int offset = originalOffset - 1; offset >= 0; --offset) {
            if (Character.isWhitespace(documentContent.charAt(offset))) {
                return -1;
            }
            if (documentContent.charAt(offset) != '.') continue;
            return originalOffset - offset + 1;
        }
        return -1;
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        if (!(context.document instanceof SchemaDocument)) {
            return List.of();
        }
        if (!this.match(context)) {
            return List.of();
        }
        int beforeDotDelta = this.previousBeforeDot(context.document.getCurrentContent(), context.position);
        if (beforeDotDelta != -1) {
            Node prevSymbol = CSTUtils.getSymbolAtPosition(context.document.getRootNode(), new Position(context.position.getLine(), context.position.getCharacter() - beforeDotDelta));
            if (prevSymbol == null) {
                return List.of();
            }
            Optional<Symbol> prevSymbolDefinition = context.schemaIndex.getSymbolDefinition(prevSymbol.getSymbol());
            if (prevSymbolDefinition.isEmpty()) {
                return List.of();
            }
            List<Symbol> fieldSymbols = context.schemaIndex.listSymbolsInScope(prevSymbolDefinition.get(), EnumSet.of(Symbol.SymbolType.FIELD, Symbol.SymbolType.MAP_KEY, Symbol.SymbolType.MAP_VALUE));
            Optional<Symbol> structDefinition = context.schemaIndex.fieldIndex().findFieldStructDefinition(prevSymbolDefinition.get());
            if (structDefinition.isPresent()) {
                fieldSymbols.addAll(context.schemaIndex.listSymbolsInScope(structDefinition.get(), Symbol.SymbolType.FIELD));
            }
            ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
            HashSet<String> addedIdentifiers = new HashSet<String>();
            for (Symbol symbol2 : fieldSymbols) {
                if (addedIdentifiers.contains(symbol2.getShortIdentifier())) continue;
                addedIdentifiers.add(symbol2.getShortIdentifier());
                ret.add(CompletionUtils.constructBasic(symbol2.getShortIdentifier(), symbol2.getLongIdentifier()));
            }
            return ret;
        }
        Optional<Symbol> scope = context.schemaIndex.findSymbol(null, Symbol.SymbolType.DOCUMENT, ((SchemaDocument)context.document).getSchemaIdentifier());
        if (scope.isEmpty()) {
            return List.of();
        }
        List<Symbol> fieldSymbols = context.schemaIndex.listSymbolsInScope(scope.get(), Symbol.SymbolType.FIELD);
        return fieldSymbols.stream().map(symbol -> CompletionUtils.constructBasic(symbol.getPrettyIdentifier())).toList();
    }
}

