/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.SchemaMessageHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.RankProfileDocument;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.schemadocument.YQLDocument;
import ai.vespa.schemals.schemadocument.resolvers.SymbolReferenceResolver;
import ai.vespa.schemals.tree.SchemaNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.TextDocumentItem;

public class SchemaDocumentScheduler {
    private Map<String, DocumentManager.DocumentType> fileExtensions = new HashMap<String, DocumentManager.DocumentType>(){
        {
            this.put("sd", DocumentManager.DocumentType.SCHEMA);
            this.put("profile", DocumentManager.DocumentType.PROFILE);
            this.put("yql", DocumentManager.DocumentType.YQL);
        }
    };
    private ClientLogger logger;
    private SchemaDiagnosticsHandler diagnosticsHandler;
    private SchemaIndex schemaIndex;
    private SchemaMessageHandler messageHandler;
    private Map<String, DocumentManager> workspaceFiles = new HashMap<String, DocumentManager>();
    private boolean reparseDescendants = true;
    private URI workspaceURI = null;

    public SchemaDocumentScheduler(ClientLogger logger, SchemaDiagnosticsHandler diagnosticsHandler, SchemaIndex schemaIndex, SchemaMessageHandler messageHandler) {
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
        this.schemaIndex = schemaIndex;
        this.messageHandler = messageHandler;
    }

    public void updateFile(String fileURI, String content) {
        this.updateFile(fileURI, content, null);
    }

    private Optional<DocumentManager.DocumentType> getDocumentTypeFromURI(String fileURI) {
        int dotIndex = fileURI.lastIndexOf(46);
        String fileExtension = fileURI.substring(dotIndex + 1).toLowerCase();
        DocumentManager.DocumentType documentType = this.fileExtensions.get(fileExtension);
        if (documentType == null) {
            return Optional.empty();
        }
        return Optional.of(documentType);
    }

    public void updateFile(final String fileURI, String content, Integer version) {
        boolean didResolve;
        Optional<DocumentManager.DocumentType> documentType = this.getDocumentTypeFromURI(fileURI);
        if (documentType.isEmpty()) {
            return;
        }
        if (!this.workspaceFiles.containsKey(fileURI)) {
            switch (documentType.get()) {
                case PROFILE: {
                    this.workspaceFiles.put(fileURI, new RankProfileDocument(this.logger, this.diagnosticsHandler, this.schemaIndex, this, fileURI));
                    break;
                }
                case SCHEMA: {
                    this.workspaceFiles.put(fileURI, new SchemaDocument(this.logger, this.diagnosticsHandler, this.schemaIndex, this, fileURI));
                    break;
                }
                case YQL: {
                    this.workspaceFiles.put(fileURI, new YQLDocument(this.logger, this.diagnosticsHandler, this.schemaIndex, this, fileURI));
                }
            }
        }
        this.workspaceFiles.get(fileURI).updateFileContent(content, version);
        if (this.reparseDescendants) {
            RankProfileDocument document;
            Optional<Symbol> optional;
            HashSet<String> parsedURIs = new HashSet<String>(){
                {
                    this.add(fileURI);
                }
            };
            if (documentType.get() == DocumentManager.DocumentType.SCHEMA) {
                this.reparseSchemaFileDescendants(fileURI, (Set<String>)parsedURIs);
            } else if (documentType.get() == DocumentManager.DocumentType.PROFILE && (optional = (document = this.getRankProfileDocument(fileURI)).schemaSymbol()).isPresent()) {
                this.reparseSchemaFileDescendants(optional.get().getFileURI(), (Set<String>)parsedURIs);
            }
        }
        HashMap undefinedSymbolDiagnostics = new HashMap();
        block5: do {
            didResolve = false;
            for (Symbol symbol : this.schemaIndex.getUnresolvedSymbols()) {
                String symbolURI = symbol.getFileURI();
                DocumentManager symbolDocument = this.getDocument(symbolURI);
                if (symbolDocument == null) continue;
                if (!undefinedSymbolDiagnostics.containsKey(symbolURI)) {
                    undefinedSymbolDiagnostics.put(symbolURI, new ArrayList());
                }
                ParseContext context = symbolDocument.getParseContext();
                if (!(symbol.getNode() instanceof SchemaNode)) continue;
                ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
                SymbolReferenceResolver.resolveSymbolReference(symbol.getNode().getSchemaNode(), context, diagnostics);
                if (!diagnostics.isEmpty()) continue;
                didResolve = true;
                continue block5;
            }
        } while (didResolve);
        for (Symbol symbol : this.schemaIndex.getUnresolvedSymbols()) {
            ((List)undefinedSymbolDiagnostics.get(symbol.getFileURI())).add(new SchemaDiagnostic.Builder().setRange(symbol.getNode().getRange()).setMessage("Undefined symbol " + symbol.getNode().getText()).setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.UNDEFINED_SYMBOL).build());
        }
        for (Map.Entry entry : undefinedSymbolDiagnostics.entrySet()) {
            this.diagnosticsHandler.replaceUndefinedSymbolDiagnostics((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private void reparseSchemaFileDescendants(String fileURI, Set<String> parsedURIs) {
        for (String descendantURI : this.schemaIndex.getDocumentInheritanceGraph().getAllDescendants(fileURI)) {
            if (parsedURIs.contains(descendantURI) || !this.workspaceFiles.containsKey(descendantURI)) continue;
            this.workspaceFiles.get(descendantURI).reparseContent();
            parsedURIs.add(descendantURI);
        }
        String schemaIdentifier = ((SchemaDocument)this.workspaceFiles.get(fileURI)).getSchemaIdentifier();
        Optional<Symbol> documentDefinition = this.schemaIndex.findSymbol(null, Symbol.SymbolType.DOCUMENT, schemaIdentifier);
        if (documentDefinition.isPresent()) {
            for (Symbol symbol : this.schemaIndex.getDocumentReferenceGraph().getAllDescendants(documentDefinition.get())) {
                String descendantURI = symbol.getFileURI();
                if (parsedURIs.contains(descendantURI) || !this.workspaceFiles.containsKey(descendantURI)) continue;
                this.workspaceFiles.get(symbol.getFileURI()).reparseContent();
                parsedURIs.add(descendantURI);
            }
        }
        for (Map.Entry entry : this.workspaceFiles.entrySet()) {
            RankProfileDocument document;
            if (parsedURIs.contains(entry.getKey()) || !(entry.getValue() instanceof RankProfileDocument) || !(document = (RankProfileDocument)entry.getValue()).schemaSymbol().isPresent() || !document.schemaSymbol().get().fileURIEquals(fileURI)) continue;
            ((DocumentManager)entry.getValue()).reparseContent();
            parsedURIs.add((String)entry.getKey());
        }
    }

    public String getWorkspaceURI() {
        if (this.workspaceURI == null) {
            return null;
        }
        return this.workspaceURI.toString();
    }

    public void openDocument(TextDocumentItem document) {
        this.logger.info("Opening document: " + document.getUri());
        Optional<DocumentManager.DocumentType> documentType = this.getDocumentTypeFromURI(document.getUri());
        if (this.workspaceURI == null && documentType.isPresent() && (documentType.get() == DocumentManager.DocumentType.SCHEMA || documentType.get() == DocumentManager.DocumentType.PROFILE)) {
            Optional<URI> workspaceURI = FileUtils.findSchemaDirectory(URI.create(document.getUri()));
            if (workspaceURI.isEmpty()) {
                this.messageHandler.sendMessage(MessageType.Warning, "The file " + document.getUri() + " does not appear to be inside a 'schemas' directory. Language support will be limited.");
            } else {
                this.setupWorkspace(workspaceURI.get());
            }
        }
        this.updateFile(document.getUri(), document.getText(), document.getVersion());
        this.workspaceFiles.get(document.getUri()).setIsOpen(true);
    }

    public void addDocument(String fileURI) {
        if (this.workspaceFiles.containsKey(fileURI)) {
            return;
        }
        try {
            this.logger.info("Adding document: " + fileURI);
            String content = FileUtils.readFromURI(fileURI);
            this.updateFile(fileURI, content);
        }
        catch (IOException ex) {
            this.logger.error("Failed to read file: " + fileURI);
        }
    }

    public void closeDocument(String fileURI) {
        this.logger.info("Closing document: " + fileURI);
        this.workspaceFiles.get(fileURI).setIsOpen(false);
        File file = new File(URI.create(fileURI));
        if (!file.exists()) {
            this.cleanUpDocument(fileURI);
        }
        if (!this.isInWorkspace(fileURI)) {
            this.diagnosticsHandler.clearDiagnostics(fileURI);
        }
    }

    private void cleanUpDocument(String fileURI) {
        this.logger.info("Removing document: " + fileURI);
        this.schemaIndex.clearDocument(fileURI);
        this.workspaceFiles.remove(fileURI);
        this.diagnosticsHandler.clearDiagnostics(fileURI);
    }

    public boolean removeDocument(String fileURI) {
        boolean wasOpen = this.workspaceFiles.get(fileURI).getIsOpen();
        this.closeDocument(fileURI);
        this.cleanUpDocument(fileURI);
        return wasOpen;
    }

    public SchemaDocument getSchemaDocument(String fileURI) {
        DocumentManager genericDocument = this.getDocument(fileURI);
        if (!(genericDocument instanceof SchemaDocument)) {
            return null;
        }
        return (SchemaDocument)genericDocument;
    }

    public RankProfileDocument getRankProfileDocument(String fileURI) {
        DocumentManager genericDocument = this.getDocument(fileURI);
        if (!(genericDocument instanceof RankProfileDocument)) {
            return null;
        }
        return (RankProfileDocument)genericDocument;
    }

    public DocumentManager getDocument(String fileURI) {
        return this.workspaceFiles.get(fileURI);
    }

    public boolean fileURIExists(String fileURI) {
        return this.workspaceFiles.containsKey(fileURI);
    }

    public void reparseInInheritanceOrder() {
        for (String fileURI : this.schemaIndex.getDocumentInheritanceGraph().getTopoOrdering()) {
            if (!this.workspaceFiles.containsKey(fileURI)) continue;
            this.workspaceFiles.get(fileURI).reparseContent();
        }
    }

    public void setReparseDescendants(boolean reparseDescendants) {
        this.reparseDescendants = reparseDescendants;
    }

    public void setupWorkspace(URI workspaceURI) {
        if (this.workspaceURI != null) {
            return;
        }
        this.workspaceURI = workspaceURI;
        this.messageHandler.logMessage(MessageType.Info, "Scanning workspace: " + workspaceURI.toString());
        this.setReparseDescendants(false);
        for (String fileURI : FileUtils.findSchemaFiles(workspaceURI.toString(), this.logger)) {
            this.messageHandler.logMessage(MessageType.Info, "Parsing file: " + fileURI);
            this.addDocument(fileURI);
        }
        for (String fileURI : FileUtils.findRankProfileFiles(workspaceURI.toString(), this.logger)) {
            this.messageHandler.logMessage(MessageType.Info, "Parsing file: " + fileURI);
            this.addDocument(fileURI);
        }
        this.reparseInInheritanceOrder();
        this.setReparseDescendants(true);
    }

    private boolean isInWorkspace(String fileURI) {
        if (this.workspaceURI == null) {
            return false;
        }
        Path filePath = Paths.get(URI.create(fileURI));
        Path workspacePath = Paths.get(this.workspaceURI);
        return filePath.startsWith(workspacePath);
    }
}

