## content

The root element of a Content cluster definition. Creates a content cluster. A content cluster stores and/or indexes documents. The xml file may have zero or more such tags.

Contained in [services](https://docs.vespa.ai/en/reference/services.html).

| Attribute |            Required            | Value  | Default |                                                                                                                                                                                                                                                                                                                                                                         Description                                                                                                                                                                                                                                                                                                                                                                         |
|-----------|--------------------------------|--------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| version   | required                       | number |         | 1.0 in this version of Vespa                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| id        | required for multiple clusters | string |         | Name of the content cluster. If none is supplied, the cluster name will be `content`. Cluster names must be unique within application, if multiple clusters are configured, name must be set for all but one at minimum. **Note:** Renaming a cluster is the same as dropping the current cluster and adding a new one. This makes data unavailable or lost, depending on hosting model. Deploying with a changed cluster id will therefore fail with a validation override requirement: `Content cluster 'music' is removed. This will cause loss of all data in this cluster. To allow this add <allow until='yyyy-mm-dd'>content-cluster-removal</allow> to validation-overrides.xml, see https://docs.vespa.ai/en/reference/validation-overrides.html`. |

Subelements:

* [documents](https://docs.vespa.ai/en/reference/services-content.html#documents) (required)
* [min-redundancy](https://docs.vespa.ai/en/reference/services-content.html#min-redundancy)
* [redundancy](https://docs.vespa.ai/en/reference/services-content.html#redundancy)
* [nodes](https://docs.vespa.ai/en/reference/services-content.html#nodes)
* [group](https://docs.vespa.ai/en/reference/services-content.html#group)
* [engine](https://docs.vespa.ai/en/reference/services-content.html#engine)
* [search](https://docs.vespa.ai/en/reference/services-content.html#search)
* [dispatch](https://docs.vespa.ai/en/reference/services-content.html#dispatch)
* [tuning](https://docs.vespa.ai/en/reference/services-content.html#tuning)

[Read more](https://docs.vespa.ai/en/reference/services-content.html#content)
