## provider

A provider is a search chain responsible for talking to an external service. Everything covered in [chain](https://docs.vespa.ai/en/reference/services-search.html#chain) is also valid for providers.

| Attribute | Required | Value  | Default |                                              Description                                              |
|-----------|----------|--------|---------|-------------------------------------------------------------------------------------------------------|
| id        | required | string |         | ID                                                                                                    |
| excludes  | optional |        |         | <br />                                                                                                |
| type      | optional | local  |         | Determines which searchers are implicitly added to this search chain to talk to the external service. |

### local provider

Local providers are providers with the type set to *local*, accessing a local Vespa cluster (i.e. a content cluster in the same application).

| Attribute | Required | Value  | Default |          Description           |
|-----------|----------|--------|---------|--------------------------------|
| cluster   | required | string |         | The name of the local cluster. |

```
<provider id="music" cluster="music" type="local" excludes="com.yahoo.prelude.querytransform.StemmingSearcher" />
```

[Read more](https://docs.vespa.ai/en/reference/services-search.html#provider)
