## filter

The definition of a single filter, for referencing when defining chains. If a single filter is to be used in different chains, it is cleaner to define it directly under `http` and then refer to it with `id`, than defining it inline separately for each chain. The following filter types are supported:

* RequestFilter
* ResponseFilter
* SecurityRequestFilter
* SecurityResponseFilter

Security\[Request/Response\]Filters are automatically wrapped in Security\[Request/Response\]FilterChains. This makes them behave like regular Request/Response filters with respect to chaining.

| Attribute | Required | Value  |   Default   |                                      Description                                      |
|-----------|----------|--------|-------------|---------------------------------------------------------------------------------------|
| id        | required | string |             | The component ID                                                                      |
| class     | optional | string | id          | The class of the component, defaults to id                                            |
| bundle    | optional | string | id or class | The bundle to load the component from, defaults to class or id (if no class is given) |
| before    | optional | string |             | Space separated list of phases and/or filters which should succeed this phase         |
| class     | optional | string | id          | Space separated list of phases and/or filters which should precede this phase         |

Sub-elements:

* [provides](https://docs.vespa.ai/en/reference/services-http.html#provides)
* [before](https://docs.vespa.ai/en/reference/services-http.html#before)
* [after](https://docs.vespa.ai/en/reference/services-http.html#after)
* [filter-config](https://docs.vespa.ai/en/reference/services-http.html#filter-config)

Example:

```
<filter id="filter2" class="com.yahoo.test.Filter2"/>
```

[Read more](https://docs.vespa.ai/en/reference/services-http.html#filter)
