## phase

Defines a phase, which is a checkpoint to help order filters. Filters and other phases may depend on a phase to be able to make assumptions about the order of filters. Contained in [chain](https://docs.vespa.ai/en/reference/services-http.html#chain).

| Attribute | Required | Value  | Default |                                                                                                         Description                                                                                                          |
|-----------|----------|--------|---------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| id        | required | string |         | The ID, or name, which other phases and filters may depend upon as a [successor](https://docs.vespa.ai/en/reference/services-http.html#before) or [predecessor](https://docs.vespa.ai/en/reference/services-http.html#after) |
| before    | optional | string |         | Space separated list of phases and/or filters which should succeed this phase                                                                                                                                                |
| after     | optional | string |         | Space separated list of phases and/or filters which should precede this phase                                                                                                                                                |

Sub-elements:

* [before](https://docs.vespa.ai/en/reference/services-http.html#before)
* [after](https://docs.vespa.ai/en/reference/services-http.html#after)

Example:

```
<request-chain id="demo">
    <phase id="CheckpointName">
        <before>Authorization</before>
    </phase>
    <filter id="filter2" class="com.yahoo.test.Filter2"/>
</request-chain>
```

[Read more](https://docs.vespa.ai/en/reference/services-http.html#phase)
