## handler

The `handler` element holds the configuration of a request handler. For each `binding` tag, the handler will be bound to the pertinent JDisc interfaces using the given binding.

* `binding` For JDisc request handlers, add this server binding to this handler.
* [`component`](https://docs.vespa.ai/en/reference/services-container.html#component) for injecting another component. Must be a declaration of a new component, not a reference.

| Attribute | Required | Value  | Default |                                                        Description                                                         |
|-----------|----------|--------|---------|----------------------------------------------------------------------------------------------------------------------------|
| id        | required | string |         | The component ID                                                                                                           |
| class     | optional | string |         | The class of the handler, defaults to id                                                                                   |
| bundle    | optional | string |         | The bundle to load the handler from: The name in \<artifactId\> in pom.xml. Defaults to class or id (if no class is given) |

Example:

```
<container id="default" version="1.0">
    <handler id="com.yahoo.search.handler.LegacyBridge">
        <binding>http://*/*</binding>
    </handler>
    <handler bundle="the name in <artifactId> in pom.xml" id="com.mydomain.vespatest.RedirectingHandler"/>
    <handler bundle="the name in <artifactId> in pom.xml" id="com.mydomain.vespatest.ExampleHandler"/>
    <nodes>
        <node hostalias="node1"/>
    </nodes>
</container>
```

[Read more](https://docs.vespa.ai/en/reference/services-container.html#handler)
