## summary

Contained in [field](https://docs.vespa.ai/en/reference/schema-reference.html#field) or [document-summary](https://docs.vespa.ai/en/reference/schema-reference.html#document-summary) or [struct-field](https://docs.vespa.ai/en/reference/schema-reference.html#struct-field). Declares a summary field.

```
summary: [property]
```

or

```
summary [name] {
    [body]
}
```

The summary *name* can be skipped if this is set inside a field. The name will then be the same as the name of the source field. *full* summary is the default. Long field values (like document content fields) should be made *dynamic* . The body of a summary may contain:

|         Name          | Occurrence  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
|-----------------------|-------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| full                  | Zero to one | Returns the full field value in the summary (the default).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| bolding: on           | Zero to one | Specifies whether the content of this field should be [bolded](https://docs.vespa.ai/en/reference/schema-reference.html#bolding). Only supported for [index](https://docs.vespa.ai/en/reference/schema-reference.html#indexing-index) fields of type string or array\<string\>.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| dynamic               | Zero to one | Make the value returned in results from this summary field be a *dynamic abstract* of the source field by extracting fragments of text around matching query terms. Matching query terms will also be highlighted, in similarity with the bolding feature. This highlighting is not affected by the query-argument bolding. The default XML element used to highlight query terms is `<hi>` - refer to [bolding](https://docs.vespa.ai/en/reference/schema-reference.html#bolding) for how to configure. *dynamic* is only supported for [index](https://docs.vespa.ai/en/reference/schema-reference.html#indexing-index) fields of type string or array\<string\>. For array\<string\> fields, a dynamic abstract is created per string item in the array.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| source                | Zero to one | Specifies the name of the field or fields from which the value of this summary field should be fetched. If multiple fields are specified, the value will be taken from the first field if that has a value, from the second if the first one is empty and so on. ``` source: [field-name], [field-name], … ``` When this is not specified, the source field is assumed to be the field with the same name as the summary field. Refer to [attribute](https://docs.vespa.ai/en/reference/schema-reference.html#add-or-remove-an-existing-document-field-from-document-summary) and [non-attribute](https://docs.vespa.ai/en/reference/schema-reference.html#add-or-remove-a-new-non-attribute-document-field-from-document-summary) fields for modifying a schema.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| to                    | Zero to one | Specifies the name of the document summaries this should be included in. ``` to: [document-summary-name], [document-summary-name], … ``` This can only be specified in fields, not in explicit document summaries. When this is not specified, the field will go to the `default` document summary.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| matched-elements-only | Zero to one | Specifies that only the matched elements in a searchable [array of primitive](https://docs.vespa.ai/en/reference/schema-reference.html#array), [weightedset](https://docs.vespa.ai/en/reference/schema-reference.html#weightedset), [array of struct](https://docs.vespa.ai/en/reference/schema-reference.html#array) or [map type](https://docs.vespa.ai/en/reference/schema-reference.html#map) field are returned as part of document summary. For array of struct or map type fields this is typically used in accordance with the [sameElement](https://docs.vespa.ai/en/reference/query-language-reference.html#sameelement) operator, but it can also be used when searching directly on a sub struct field. Is also supported when the field is [imported](https://docs.vespa.ai/en/reference/schema-reference.html#import-field). Is not supported for [index](https://docs.vespa.ai/en/reference/schema-reference.html#index) fields in indexed search. Example .sd files from system tests: * [matched elements only](https://github.com/vespa-engine/system-test/blob/master/tests/search/matched_elements_only/indexed/test.sd) * [array of struct and map type](https://github.com/vespa-engine/system-test/blob/master/tests/search/struct_and_map_types/attribute_fields/test.sd) |
| tokens                | Zero to one | Make the value returned in results from this summary field be an array of the tokens indexed in the source field. Multiple tokens at the same location are put into a nested array. The source field must be specified and it must be an [index](https://docs.vespa.ai/en/reference/schema-reference.html#indexing-index) or [attribute](https://docs.vespa.ai/en/reference/schema-reference.html#indexing-attribute) field of type string, array\<string\> or weightedset\<string\>. If the source field is of type weightedset\<string\> then the summary field is rendered as if the source field was of type array\<string\>, weights are not shown. This is mainly useful for [linguistics transformations debugging](https://docs.vespa.ai/en/text-matching.html#tokens-example), to correlate query trace with the tokens indexed.                                                                                                                                                                                                                                                                                                                                                                                                                                                         |

Read more about [document summaries](https://docs.vespa.ai/en/document-summaries.html).
[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#summary)
