## attribute

Contained in [field](https://docs.vespa.ai/en/reference/schema-reference.html#field) or [struct-field](https://docs.vespa.ai/en/reference/schema-reference.html#struct-field). Specifies a property of an index structure attribute:

```
attribute [attribute-name]: [property]
```

or

```
attribute [attribute-name] {
    [property]
    [property]
    …
}
```

Read the [introduction to attributes](https://docs.vespa.ai/en/attributes.html) . If attribute name is specified it will be used instead of the field name as name of the attribute.  
**Deprecated:** Deprecated, use a field with the wanted name outside the document instead.
Actions required when [adding or modifying attributes](https://docs.vespa.ai/en/reference/schema-reference.html#modifying-schemas) . Properties:

|                                          Property                                           |                                                                                                                                                                                                                                                                                                                                                                                                                     Description                                                                                                                                                                                                                                                                                                                                                                                                                      |
|---------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| fast-search                                                                                 | Create a dictionary / index structure to speed up search in the attribute. [Read more](https://docs.vespa.ai/en/attributes.html#index-structures).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| fast-access                                                                                 | If [searchable-copies](https://docs.vespa.ai/en/reference/services-content.html#searchable-copies) \< [redundancy](https://docs.vespa.ai/en/reference/services-content.html#redundancy), use *fast-access* to load the attribute in memory on all nodes with a document replica. Use this for fast access when doing [partial updates](https://docs.vespa.ai/en/reads-and-writes.html) and when used in a [selection expression](https://docs.vespa.ai/en/reference/services-content.html#documents) for garbage collection. If [searchable-copies](https://docs.vespa.ai/en/reference/services-content.html#searchable-copies) == [redundancy](https://docs.vespa.ai/en/reference/services-content.html#redundancy) (default), this property is a no-op. [Read more](https://docs.vespa.ai/en/performance/sizing-feeding.html#redundancy-settings). |
| fast-rank                                                                                   | Only supported for [tensor](https://docs.vespa.ai/en/tensor-user-guide.html) field types with at least one mapped dimension. Ensures that the per-document tensors are stored in-memory using a format that is more optimal for [ranking expression](https://docs.vespa.ai/en/reference/ranking-expressions.html) evaluation. This comes at the cost of using more memory. Without this setting these tensors are serialized in-memory, which requires de-serialization as part of ranking expression evaluation. See [tensor performance](https://docs.vespa.ai/en/performance/feature-tuning.html#tensor-ranking).                                                                                                                                                                                                                                 |
| paged                                                                                       | This can reduce memory footprint by allowing paging the attribute data out of memory to disk. Not supported for [tensor](https://docs.vespa.ai/en/reference/schema-reference.html#tensor) with fast-rank and [predicate](https://docs.vespa.ai/en/reference/schema-reference.html#predicate) types. See [paged attributes](https://docs.vespa.ai/en/attributes.html#paged-attributes) for details. Do not enable *paged* before fully understanding the consequences.                                                                                                                                                                                                                                                                                                                                                                                |
| [sorting](https://docs.vespa.ai/en/reference/schema-reference.html#sorting)                 | The sort specification for this attribute.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| [distance-metric](https://docs.vespa.ai/en/reference/schema-reference.html#distance-metric) | Specifies the distance metric to use with the [nearestNeighbor](https://docs.vespa.ai/en/reference/query-language-reference.html#nearestneighbor) query operator. Only relevant for tensor attribute fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| mutable                                                                                     | Marks the attribute as a special mutable attribute that can be updated by a [mutate](https://docs.vespa.ai/en/reference/schema-reference.html#mutate) operation during query evaluation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |

An attribute is [multivalued](https://docs.vespa.ai/en/schemas.html#field) if assigning it multiple values during indexing, by using a multivalued field type like array or map, or by using e.g. [split](https://docs.vespa.ai/en/reference/indexing-language-reference.html#split) / [for_each](https://docs.vespa.ai/en/reference/indexing-language-reference.html#for_each) or by letting multiple fields write their value to the attribute field.

Note that [normalizing](https://docs.vespa.ai/en/reference/schema-reference.html#normalizing) and [tokenization](https://docs.vespa.ai/en/linguistics.html#tokenization) is not supported for attribute fields. Queries in attribute fields are not normalized, nor stemmed. Use [index](https://docs.vespa.ai/en/reference/schema-reference.html#index) on fields to enable. Both *index* and *attribute* can be set on a field.
[Read more](https://docs.vespa.ai/en/reference/schema-reference.html#attribute)
