/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.completion.provider;

import ai.vespa.schemals.common.StringUtils;
import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.schema.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.schema.completion.utils.CompletionUtils;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;

public class TypeCompletion
implements CompletionProvider {
    private Token.TokenType[] compoundTypes = new Token.TokenType[]{Token.TokenType.MAP, Token.TokenType.ARRAY, Token.TokenType.WEIGHTEDSET};

    private boolean match(EventCompletionContext context) {
        SchemaDocumentLexer lexer = context.document.lexer();
        SchemaNode match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.FIELD, Token.TokenType.IDENTIFIER, Token.TokenType.TYPE);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return true;
        }
        match = lexer.matchBackwards(context.position, 1, false, Token.TokenType.FIELD, Token.TokenType.IDENTIFIER, Token.TokenType.TYPE, Token.TokenType.IDENTIFIER);
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
            return true;
        }
        for (Token.TokenType tokenType : this.compoundTypes) {
            match = lexer.matchBackwards(context.position, 3, true, tokenType, Token.TokenType.LESSTHAN);
            if (match != null && match.getRange().getStart().getLine() == context.position.getLine()) {
                return true;
            }
            match = lexer.tokenAtOrBeforePosition(context.position, false);
            if (match == null || match.getDirtyType() != Token.TokenType.GREATERTHAN || !match.getIsDirty()) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideTensor(EventCompletionContext context) {
        int offset;
        Node lastClean = CSTUtils.getLastCleanNode(context.document.getRootNode(), context.position);
        if (!lastClean.getText().startsWith("tensor")) {
            return false;
        }
        String content = context.document.getCurrentContent();
        for (int i = offset = StringUtils.positionToOffset(content, context.position) - 1; i >= offset - 20; --i) {
            if (content.charAt(i) == '>') {
                return false;
            }
            if (content.charAt(i) != '<') continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        if (!(context.document instanceof SchemaDocument)) {
            return List.of();
        }
        if (!this.match(context)) {
            return List.of();
        }
        if (this.isInsideTensor(context)) {
            return List.of(CompletionUtils.constructType("float"), CompletionUtils.constructType("double"), CompletionUtils.constructType("int8"), CompletionUtils.constructType("bfloat16"));
        }
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>(){
            {
                this.add(CompletionUtils.constructSnippet("annotationreference", "annotationreference<$1>"));
                this.add(CompletionUtils.constructSnippet("array", "array<$1>"));
                this.add(CompletionUtils.constructType("bool"));
                this.add(CompletionUtils.constructType("byte"));
                this.add(CompletionUtils.constructType("double"));
                this.add(CompletionUtils.constructType("float"));
                this.add(CompletionUtils.constructType("int"));
                this.add(CompletionUtils.constructType("long"));
                this.add(CompletionUtils.constructSnippet("map", "map<${1:Kt}, ${2:Vt}>"));
                this.add(CompletionUtils.constructType("position"));
                this.add(CompletionUtils.constructType("predicate"));
                this.add(CompletionUtils.constructType("raw"));
                this.add(CompletionUtils.constructSnippet("reference", "reference<$1>"));
                this.add(CompletionUtils.constructType("string"));
                this.add(CompletionUtils.constructSnippet("tensor", "tensor<$1>($0)"));
                this.add(CompletionUtils.constructType("uri"));
                this.add(CompletionUtils.constructSnippet("weightedset", "weightedset<$1>"));
            }
        };
        Optional<Symbol> documentScope = context.schemaIndex.findSymbol(null, Symbol.SymbolType.DOCUMENT, ((SchemaDocument)context.document).getSchemaIdentifier());
        if (documentScope.isPresent()) {
            List<Symbol> structSymbols = context.schemaIndex.listSymbolsInScope(documentScope.get(), Symbol.SymbolType.STRUCT);
            for (Symbol symbol : structSymbols) {
                items.add(CompletionUtils.constructType(symbol.getShortIdentifier()));
            }
        }
        return items;
    }
}

