/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.common;

import ai.vespa.schemals.common.ClientLogger;
import com.yahoo.io.IOUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FileUtils {
    public static String fileNameFromPath(String path) {
        int splitPos = path.lastIndexOf(47);
        return path.substring(splitPos + 1);
    }

    public static String schemaNameFromPath(String path) {
        String fileName = FileUtils.fileNameFromPath(path);
        int splitPos = fileName.lastIndexOf(46);
        if (splitPos == -1) {
            return "";
        }
        String res = fileName.substring(0, splitPos);
        if (res == null) {
            return "";
        }
        return res;
    }

    public static String readFromURI(String fileURI) throws IOException {
        File file = new File(URI.create(fileURI));
        return IOUtils.readAll((Reader)new FileReader(file));
    }

    public static List<String> findSchemaFiles(String workspaceFolderUri, ClientLogger logger) {
        return FileUtils.walkFileTree(Paths.get(URI.create(workspaceFolderUri)), "glob:**/*.sd", logger);
    }

    public static List<String> findRankProfileFiles(String workspaceFolderUri, ClientLogger logger) {
        return FileUtils.walkFileTree(Paths.get(URI.create(workspaceFolderUri)), "glob:**/*/*.profile", logger);
    }

    public static String firstPathComponentAfterPrefix(String pathURIStr, String prefixURIStr) {
        URI pathURI = URI.create(pathURIStr);
        URI prefixURI = URI.create(prefixURIStr);
        URI relativeURI = prefixURI.relativize(pathURI);
        if (relativeURI.isAbsolute()) {
            return null;
        }
        String relativePath = relativeURI.getPath();
        if (relativePath == null) {
            return null;
        }
        String[] components = relativePath.split("/");
        if (components.length == 0) {
            return null;
        }
        return components[0];
    }

    public static Optional<URI> findSchemaDirectory(URI initialURI) {
        Path path;
        for (path = Paths.get(initialURI); path != null && path.getFileName() != null && !path.getFileName().toString().equals("schemas"); path = path.getParent()) {
        }
        if (path == null || path.getFileName() == null) {
            return Optional.empty();
        }
        return Optional.of(path.toUri());
    }

    private static List<String> walkFileTree(Path rootDir, String pathMatcherStr, ClientLogger logger) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher(pathMatcherStr);
        final ArrayList<String> filePaths = new ArrayList<String>();
        try {
            Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (pathMatcher.matches(path)) {
                        filePaths.add(path.toUri().toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            logger.error("IOException caught when walking file tree: " + ex.getMessage());
        }
        return filePaths;
    }
}

