## requestthreads

Contained in [searchnode](https://docs.vespa.ai/en/reference/services-content.html#searchnode), optional. Tune the number of request threads used on a content node, see [thread-configuration](https://docs.vespa.ai/en/performance/sizing-search.html#thread-configuration) for details. Sub-elements:

|  Element  | Required | Default |                                                                                                                                                                                                                     Description                                                                                                                                                                                                                     |
|-----------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| search    | Optional | 64      | Number of search threads.                                                                                                                                                                                                                                                                                                                                                                                                                           |
| persearch | Optional | 1       | Number of search threads. Number of search threads used per search, see the [Vespa serving scaling guide](https://docs.vespa.ai/en/performance/sizing-search.html) for an introduction of using multiple threads per search per node to reduce query latency. Number of threads per search can be adjusted down per *rank-profile* using [num-threads-per-search](https://docs.vespa.ai/en/reference/schema-reference.html#num-threads-per-search). |
| summary   | Optional | 16      | Number of summary threads.                                                                                                                                                                                                                                                                                                                                                                                                                          |


```xml
<requestthreads>
    <search>64</search>
    <persearch>1</persearch>
    <summary>16</summary>
</requestthreads>

```


[Read more](https://docs.vespa.ai/en/reference/services-content.html#requestthreads)
