## server

The definition of a http server. Configure the server using [jdisc.http.connector.def](https://github.com/vespa-engine/vespa/blob/master/container-core/src/main/resources/configdefinitions/jdisc.http.jdisc.http.connector.def).

|       Attribute        | Required | Value  |                                                                          Default                                                                          |                       Description                        |
|------------------------|----------|--------|-----------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------|
| id                     | required | string |                                                                                                                                                           | The component ID                                         |
| port                   | optional | number | The web services port of the [environment variables](https://docs.vespa.ai/en/operations-selfhosted/files-processes-and-ports.html#environment-variables) | Server port                                              |
| default-request-chain  | optional | string |                                                                                                                                                           | The default request chain to use for unmatched requests  |
| default-response-chain | optional | string |                                                                                                                                                           | The default response chain to use for unmatched requests |

Example:

```
<server id="server1" port="8080">
    <config name="jdisc.http.connector">
        <idleTimeout>90</idleTimeout>
    </config>
</server>
```

[Read more](https://docs.vespa.ai/en/reference/services-http.html#server)
