/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Position;

public class SchemaDocumentLexer {
    private SchemaNode CST;
    private List<SchemaNode> tokens = new ArrayList<SchemaNode>();

    public void setCST(SchemaNode CST) {
        this.CST = CST;
        this.tokens.clear();
        this.collectAllTokens(CST);
    }

    public void dumpTokens(ClientLogger logger) {
        for (SchemaNode node : this.tokens) {
            Position start = node.getRange().getStart();
            Position end = node.getRange().getEnd();
            logger.info(node.getDirtyType().toString() + (node.getIsDirty() ? " [DIRTY]" : "") + ", (" + start.getLine() + ", " + start.getCharacter() + ") - (" + end.getLine() + ", " + end.getCharacter() + ")");
        }
    }

    public SchemaNode tokenAtOrBeforePosition(Position pos, boolean skipNL) {
        int index = this.indexOfPosition(pos, skipNL);
        if (index == -1) {
            return null;
        }
        return this.tokens.get(index);
    }

    public SchemaNode matchBackwards(Position pos, int allowSkip, boolean allowDirty, Token.TokenType ... pattern) {
        int index = this.indexOfPosition(pos, false);
        if (index == -1) {
            return null;
        }
        int skipped = 0;
        for (int patternStart = index - pattern.length + 1; patternStart >= 0 && skipped <= allowSkip; --patternStart, ++skipped) {
            boolean matched = true;
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] != this.tokens.get(patternStart + i).getDirtyType()) {
                    matched = false;
                }
                if (!this.tokens.get(patternStart + i).getIsDirty() || allowDirty) continue;
                matched = false;
            }
            if (!matched) continue;
            return this.tokens.get(patternStart);
        }
        return null;
    }

    public SchemaNode matchBackwardsOnLine(Position pos, boolean allowDirty, Token.TokenType ... pattern) {
        int index = this.indexOfPosition(pos, false);
        if (index == -1) {
            return null;
        }
        for (int patternStart = index - pattern.length + 1; patternStart >= 0; --patternStart) {
            boolean matched = true;
            if (this.tokens.get(patternStart).getRange().getStart().getLine() != pos.getLine()) break;
            for (int i = 0; i < pattern.length; ++i) {
                if (pattern[i] != this.tokens.get(patternStart + i).getDirtyType()) {
                    matched = false;
                }
                if (!this.tokens.get(patternStart + i).getIsDirty() || allowDirty) continue;
                matched = false;
            }
            if (!matched) continue;
            return this.tokens.get(patternStart);
        }
        return null;
    }

    private int indexOfPosition(Position pos, boolean skipNL) {
        int lastIndex = -1;
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (skipNL && this.tokens.get(i).getDirtyType() == Token.TokenType.NL) continue;
            if (CSTUtils.positionLT(pos, this.tokens.get(i).getRange().getStart())) break;
            lastIndex = i;
        }
        return lastIndex;
    }

    private void collectAllTokens(SchemaNode node) {
        if (node == null) {
            return;
        }
        if (node.getDirtyType() != null) {
            this.tokens.add(node);
        }
        for (SchemaNode child : node) {
            this.collectAllTokens(child);
        }
    }
}

