/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.documentation;

import ai.vespa.schemals.documentation.ContentFetcher;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class ServicesDocumentationFetcher
extends ContentFetcher {
    ServicesDocumentationFetcher(String relativeFileUrl) {
        super(relativeFileUrl);
    }

    @Override
    Map<String, String> getMarkdownContent() throws IOException {
        Document schemaDoc = Jsoup.connect((String)("https://docs.vespa.ai/" + this.fileUrl)).get();
        Element prevH2 = null;
        HashMap<String, HTMLContentEntry> htmlContents = new HashMap<String, HTMLContentEntry>();
        for (Element nodeIterator = schemaDoc.selectFirst("h2"); nodeIterator != null; nodeIterator = nodeIterator.nextSibling()) {
            Element element = null;
            if (nodeIterator instanceof Element && (element = nodeIterator).tag().equals((Object)Tag.valueOf((String)"h2"))) {
                prevH2 = element;
            }
            if (prevH2 == null) continue;
            String contentKey = prevH2.text();
            if (!htmlContents.containsKey(contentKey)) {
                htmlContents.put(contentKey, new HTMLContentEntry(new StringBuilder().append(prevH2.outerHtml()), prevH2.id()));
                continue;
            }
            StringBuilder currentBuilder = ((HTMLContentEntry)htmlContents.get(contentKey)).htmlContent();
            currentBuilder.append("\n");
            if (element == null) {
                if (nodeIterator.toString().isBlank()) continue;
                currentBuilder.append(nodeIterator.toString());
                continue;
            }
            if (element.tag().equals((Object)Tag.valueOf((String)"table"))) {
                Element tbody = element.selectFirst("tbody");
                tbody.select("th").tagName("td");
            }
            currentBuilder.append(element.outerHtml());
        }
        HashMap<String, String> result = new HashMap<String, String>();
        FlexmarkHtmlConverter converter = this.getHtmlParser();
        for (Map.Entry entry : htmlContents.entrySet()) {
            StringBuilder htmlContent = ((HTMLContentEntry)entry.getValue()).htmlContent();
            String h2id = ((HTMLContentEntry)entry.getValue()).h2ID();
            URI readMoreLink = URI.create("https://docs.vespa.ai/").resolve(this.fileUrl).resolve("#" + h2id);
            htmlContent.append("<a href=\"" + readMoreLink + "\">Read more</a>");
            String md = converter.convert(htmlContent.toString());
            md = md.replaceAll("````\n", "");
            result.put((String)entry.getKey(), md);
        }
        return result;
    }

    private record HTMLContentEntry(StringBuilder htmlContent, String h2ID) {
    }
}

