/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.index;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldOutsideDoc;
import ai.vespa.schemals.parser.ast.importField;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FieldIndex {
    private Map<Symbol, FieldIndexEntry> database = new HashMap<Symbol, FieldIndexEntry>();
    private ClientLogger logger;
    private SchemaIndex schemaIndex;

    public FieldIndex(ClientLogger logger, SchemaIndex schemaIndex) {
        this.logger = logger;
        this.schemaIndex = schemaIndex;
    }

    public void clearFieldsByURI(URI fileURI) {
        Iterator<Map.Entry<Symbol, FieldIndexEntry>> it = this.database.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Symbol, FieldIndexEntry> entry = it.next();
            if (!entry.getKey().fileURIEquals(fileURI)) continue;
            it.remove();
        }
    }

    public void insertFieldDefinition(Symbol fieldDefinition) {
        if (fieldDefinition.getStatus() != Symbol.SymbolStatus.DEFINITION || fieldDefinition.getType() != Symbol.SymbolType.FIELD) {
            throw new IllegalArgumentException("Only field definitions should be stored in FieldIndex!");
        }
        if (this.database.containsKey(fieldDefinition)) {
            return;
        }
        SchemaNode dataTypeNode = this.resolveFieldDataTypeNode(fieldDefinition);
        this.database.put(fieldDefinition, new FieldIndexEntry(dataTypeNode, this.resolveIsInsideDoc(fieldDefinition)));
    }

    public void addFieldIndexingType(Symbol fieldDefinition, IndexingType indexingType) {
        this.insertFieldDefinition(fieldDefinition);
        FieldIndexEntry entry = this.database.get(fieldDefinition);
        entry.indexingTypes.add(indexingType);
        if (indexingType == IndexingType.ATTRIBUTE && fieldDefinition.getScope() != null && fieldDefinition.getScope().getType() == Symbol.SymbolType.FIELD && fieldDefinition.getScope().getStatus() == Symbol.SymbolStatus.DEFINITION) {
            this.addFieldIndexingType(fieldDefinition.getScope(), indexingType);
        }
    }

    public Optional<SchemaNode> getFieldDataTypeNode(Symbol fieldDefinition) {
        FieldIndexEntry entry = this.database.get(fieldDefinition);
        if (entry == null) {
            return Optional.empty();
        }
        if (entry.dataTypeNode != null) {
            return Optional.of(entry.dataTypeNode);
        }
        entry.dataTypeNode = this.resolveFieldDataTypeNode(fieldDefinition);
        return Optional.ofNullable(entry.dataTypeNode);
    }

    public EnumSet<IndexingType> getFieldIndexingTypes(Symbol fieldDefinition) {
        FieldIndexEntry entry = this.database.get(fieldDefinition);
        if (entry == null) {
            return EnumSet.noneOf(IndexingType.class);
        }
        return EnumSet.copyOf(entry.indexingTypes);
    }

    public boolean getIsInsideDoc(Symbol fieldDefinition) {
        FieldIndexEntry entry = this.database.get(fieldDefinition);
        if (entry == null) {
            return false;
        }
        return entry.isInsideDoc;
    }

    public Optional<Symbol> findFieldStructDefinition(Symbol fieldDefinition) {
        Optional<SchemaNode> dataTypeNode = this.getFieldDataTypeNode(fieldDefinition);
        if (dataTypeNode.isEmpty()) {
            return Optional.empty();
        }
        if (dataTypeNode.get().hasSymbol()) {
            if (dataTypeNode.get().getSymbol().getType() != Symbol.SymbolType.STRUCT) {
                return Optional.empty();
            }
            return this.schemaIndex.getSymbolDefinition(dataTypeNode.get().getSymbol());
        }
        dataType originalNode = (dataType)dataTypeNode.get().getOriginalSchemaNode();
        if (originalNode.getParsedType().getVariant() == ParsedType.Variant.MAP) {
            return Optional.of(fieldDefinition);
        }
        if (originalNode.getParsedType().getVariant() == ParsedType.Variant.ARRAY) {
            if (dataTypeNode.get().size() < 3 || !dataTypeNode.get().get(2).isASTInstance(dataType.class)) {
                return Optional.empty();
            }
            SchemaNode innerType = dataTypeNode.get().get(2);
            if (!innerType.hasSymbol() || innerType.getSymbol().getType() != Symbol.SymbolType.STRUCT) {
                return Optional.empty();
            }
            Symbol structReference = innerType.getSymbol();
            return this.schemaIndex.getSymbolDefinition(structReference);
        }
        return Optional.empty();
    }

    private SchemaNode resolveFieldDataTypeNode(Symbol fieldDefinition) {
        fieldDefinition = this.schemaIndex.getFirstSymbolDefinition(fieldDefinition).get();
        return this.resolveFieldDataTypeNode(fieldDefinition, new HashSet<Symbol>());
    }

    private SchemaNode resolveFieldDataTypeNode(Symbol fieldDefinition, Set<Symbol> visited) {
        if (visited.contains(fieldDefinition)) {
            return null;
        }
        visited.add(fieldDefinition);
        SchemaNode fieldDefinitionNode = fieldDefinition.getNode();
        if (fieldDefinitionNode.isASTInstance(dataType.class)) {
            return fieldDefinitionNode;
        }
        if (fieldDefinitionNode.getParent().isASTInstance(importField.class)) {
            SchemaNode importReferenceNode = fieldDefinitionNode.getPreviousSibling().getPreviousSibling();
            if (!importReferenceNode.hasSymbol() || importReferenceNode.getSymbol().getStatus() != Symbol.SymbolStatus.REFERENCE) {
                return null;
            }
            Optional<Symbol> referencedField = this.schemaIndex.getSymbolDefinition(importReferenceNode.getSymbol());
            if (referencedField.isEmpty()) {
                return null;
            }
            return this.resolveFieldDataTypeNode(referencedField.get(), visited);
        }
        if (fieldDefinitionNode.getNextSibling() != null && fieldDefinitionNode.getNextSibling().getNextSibling() != null && fieldDefinitionNode.getNextSibling().getNextSibling().isASTInstance(dataType.class)) {
            return fieldDefinitionNode.getNextSibling().getNextSibling();
        }
        return null;
    }

    private boolean resolveIsInsideDoc(Symbol fieldDefinition) {
        if (fieldDefinition.getScope() != null && fieldDefinition.getScope().getType() == Symbol.SymbolType.FIELD && fieldDefinition.getScope().getStatus() == Symbol.SymbolStatus.DEFINITION) {
            return this.resolveIsInsideDoc(fieldDefinition.getScope());
        }
        SchemaNode fieldDefinitionNode = fieldDefinition.getNode();
        if (fieldDefinitionNode.getParent().isASTInstance(importField.class)) {
            return false;
        }
        return !fieldDefinitionNode.getParent().getParent().isASTInstance(fieldOutsideDoc.class);
    }

    public void dumpIndex() {
        for (Map.Entry<Symbol, FieldIndexEntry> entry : this.database.entrySet()) {
            this.logger.info(entry.getKey().toString() + " -> " + entry.getValue().toString());
        }
    }

    public class FieldIndexEntry {
        public SchemaNode dataTypeNode;
        public EnumSet<IndexingType> indexingTypes = EnumSet.noneOf(IndexingType.class);
        public boolean isInsideDoc = true;

        FieldIndexEntry(SchemaNode dataTypeNode, boolean isInsideDoc) {
            this.dataTypeNode = dataTypeNode;
            this.isInsideDoc = isInsideDoc;
        }

        public String toString() {
            return (this.dataTypeNode == null ? " unknown type" : this.dataTypeNode.toString()) + " " + this.indexingTypes.toString() + " " + (this.isInsideDoc ? " in document" : " in schema");
        }
    }

    public static enum IndexingType {
        ATTRIBUTE,
        INDEX,
        SUMMARY;

    }
}

