/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.codeaction;

import ai.vespa.schemals.context.EventCodeActionContext;
import ai.vespa.schemals.lsp.codeaction.provider.CodeActionProvider;
import ai.vespa.schemals.lsp.codeaction.provider.QuickFixProvider;
import ai.vespa.schemals.lsp.codeaction.provider.RefactorRewriteProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class SchemaCodeAction {
    private static Map<String, CodeActionProvider> providers = new HashMap<String, CodeActionProvider>(){
        {
            this.put("quickfix", new QuickFixProvider());
            this.put("refactor.rewrite", new RefactorRewriteProvider());
        }
    };

    public static List<Either<Command, CodeAction>> provideActions(EventCodeActionContext context) {
        ArrayList<Either<Command, CodeAction>> result = new ArrayList<Either<Command, CodeAction>>();
        for (String actionKind : context.codeActionKinds) {
            CodeActionProvider provider = providers.get(actionKind);
            if (provider == null) continue;
            result.addAll(provider.getActions(context));
        }
        return result;
    }

    public static CodeAction resolveAction(CodeAction unresolved) {
        return null;
    }
}

