/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.parser.ast.fieldOutsideDoc;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.structFieldElm;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IdentifyDeprecatedToken
extends Identifier {
    private static final HashMap<Token.TokenType, DeprecatedToken> deprecatedTokens = new HashMap<Token.TokenType, DeprecatedToken>(){
        {
            this.put(Token.TokenType.ENABLE_BIT_VECTORS, new DeprecatedToken("", SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_ENABLE_BIT_VECTORS));
            this.put(Token.TokenType.SUMMARY_TO, new DeprecatedToken("", SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_SUMMARY_TO));
            this.put(Token.TokenType.SEARCH, new DeprecatedToken("Use schema instead.", SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_SEARCH));
        }
    };

    public IdentifyDeprecatedToken(ParseContext context) {
        super(context);
    }

    public ArrayList<Diagnostic> identify(SchemaNode node) {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        DeprecatedToken entry = deprecatedTokens.get(node.getSchemaType());
        if (entry != null) {
            ret.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(node.getText() + " is deprecated. " + entry.message).setSeverity(DiagnosticSeverity.Warning).setCode(entry.code).build());
            return ret;
        }
        if ((node.getSchemaType() == Token.TokenType.ATTRIBUTE || node.getSchemaType() == Token.TokenType.INDEX) && node.getNextSibling() != null && node.getNextSibling().isASTInstance(identifierStr.class)) {
            SchemaNode fieldNode;
            SchemaDiagnostic.DiagnosticCode code;
            String offendingKind;
            if (node.getSchemaType() == Token.TokenType.ATTRIBUTE) {
                offendingKind = "attribute";
                code = SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_ATTRIBUTE;
            } else {
                offendingKind = "index";
                code = SchemaDiagnostic.DiagnosticCode.DEPRECATED_TOKEN_INDEX;
            }
            String attributeName = node.getNextSibling().getText();
            for (fieldNode = node; fieldNode != null && !fieldNode.isASTInstance(structFieldElm.class) && !fieldNode.isASTInstance(fieldElm.class); fieldNode = fieldNode.getParent()) {
            }
            if (fieldNode != null && !fieldNode.get(1).getText().equals(attributeName)) {
                String fieldIdentifier = fieldNode.get(1).getText();
                if (fieldNode.getParent().isASTInstance(fieldOutsideDoc.class)) {
                    ret.add(new SchemaDiagnostic.Builder().setRange(node.getNextSibling().getRange()).setMessage("Cannot create " + offendingKind + " '" + attributeName + "' in field '" + fieldIdentifier + "' outside document.").setSeverity(DiagnosticSeverity.Error).build());
                } else {
                    ret.add(new SchemaDiagnostic.Builder().setRange(node.getNextSibling().getRange()).setMessage("Creating an " + offendingKind + " for field '" + fieldIdentifier + "' with a different name '" + attributeName + "' than the field name is deprecated, and support will be removed in Vespa 9.  Create a field with the wanted name outside the document instead.").setSeverity(DiagnosticSeverity.Warning).setCode(code).build());
                }
            }
        }
        return ret;
    }

    private record DeprecatedToken(String message, SchemaDiagnostic.DiagnosticCode code) {
    }
}

