/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.LogTraceParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.ShowDocumentResult;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.services.LanguageClient;

public class SchemaMessageHandler {
    private LanguageClient client;
    private String traceValue = "off";

    void connectClient(LanguageClient client) {
        this.client = client;
    }

    public boolean connected() {
        return this.client != null;
    }

    public void sendMessage(MessageType messageType, String message) {
        this.client.showMessage(new MessageParams(messageType, message));
    }

    public void logMessage(MessageType messageType, String message) {
        this.client.logMessage(new MessageParams(messageType, message));
    }

    public void setTraceValue(String newTraceValue) {
        this.traceValue = newTraceValue;
    }

    public void verboseTrace(String logMessage) {
        if (!this.traceValue.equals("verbose")) {
            return;
        }
        this.client.logTrace(new LogTraceParams(logMessage));
    }

    public void messageTrace(String logMessage) {
        if (this.traceValue.equals("off")) {
            return;
        }
        this.client.logTrace(new LogTraceParams(logMessage));
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(String message, List<MessageActionItem> actions) {
        ShowMessageRequestParams params = new ShowMessageRequestParams(actions);
        params.setMessage(message);
        params.setType(MessageType.Info);
        return this.client.showMessageRequest(params);
    }

    public CompletableFuture<ShowDocumentResult> showDocument(String fileURI) {
        return this.client.showDocument(new ShowDocumentParams(fileURI));
    }
}

