/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate;

import com.yahoo.api.annotations.Beta;

@Beta
public class Hit
implements Comparable<Hit> {
    private final int docId;
    private final long subquery;

    public Hit(int docId) {
        this(docId, -1L);
    }

    public Hit(int docId, long subquery) {
        this.docId = docId;
        this.subquery = subquery;
    }

    public String toString() {
        if (this.subquery == -1L) {
            return "" + this.docId;
        }
        return "[" + this.docId + ",0x" + Long.toHexString(this.subquery) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hit hit = (Hit)o;
        if (this.docId != hit.docId) {
            return false;
        }
        return this.subquery == hit.subquery;
    }

    public int hashCode() {
        int result = this.docId;
        result = 31 * result + (int)(this.subquery ^ this.subquery >>> 32);
        return result;
    }

    public int getDocId() {
        return this.docId;
    }

    public long getSubquery() {
        return this.subquery;
    }

    @Override
    public int compareTo(Hit o) {
        return Integer.compare(this.docId, o.docId);
    }
}

