/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.yahoo.search.predicate.PredicateQuery;
import com.yahoo.search.predicate.PredicateQueryParser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PredicateQuerySerializer {
    private final JsonFactory factory = new JsonFactory();
    private final PredicateQueryParser parser = new PredicateQueryParser();

    public String toJSON(PredicateQuery query) {
        try {
            StringWriter writer = new StringWriter(1024);
            this.toJSON(query, writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toJSON(PredicateQuery query, Writer writer) throws IOException {
        try (JsonGenerator g = this.factory.createGenerator(writer);){
            g.writeStartObject();
            g.writeArrayFieldStart("features");
            for (PredicateQuery.Feature feature : query.getFeatures()) {
                PredicateQuerySerializer.writeFeature(feature.key, feature.value, feature.subqueryBitmap, g, JsonGenerator::writeStringField);
            }
            g.writeEndArray();
            g.writeArrayFieldStart("rangeFeatures");
            for (PredicateQuery.RangeFeature rangeFeature : query.getRangeFeatures()) {
                PredicateQuerySerializer.writeFeature(rangeFeature.key, rangeFeature.value, rangeFeature.subqueryBitmap, g, JsonGenerator::writeNumberField);
            }
            g.writeEndArray();
            g.writeEndObject();
        }
    }

    private static <T> void writeFeature(String key, T value, long subqueryBitmap, JsonGenerator g, ValueWriter<T> valueWriter) throws IOException {
        g.writeStartObject();
        g.writeStringField("k", key);
        valueWriter.write(g, "v", value);
        if (subqueryBitmap != -1L) {
            g.writeStringField("s", PredicateQuerySerializer.toHexString(subqueryBitmap));
        }
        g.writeEndObject();
    }

    public PredicateQuery fromJSON(String json) {
        PredicateQuery query = new PredicateQuery();
        this.parser.parseJsonQuery(json, query::addFeature, query::addRangeFeature);
        return query;
    }

    public static List<PredicateQuery> parseQueriesFromFile(String queryFile, int maxQueryCount) throws IOException {
        PredicateQuerySerializer serializer = new PredicateQuerySerializer();
        try (BufferedReader reader = new BufferedReader(new FileReader(queryFile), 8192);){
            List<PredicateQuery> list = reader.lines().limit(maxQueryCount).map(serializer::fromJSON).toList();
            return list;
        }
    }

    private static String toHexString(long subqueryBitMap) {
        return "0x" + Long.toHexString(subqueryBitMap);
    }

    @FunctionalInterface
    private static interface ValueWriter<T> {
        public void write(JsonGenerator var1, String var2, T var3) throws IOException;
    }
}

