/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.index.conjunction;

import com.yahoo.document.predicate.FeatureConjunction;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.index.Feature;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexableFeatureConjunction {
    public final long id;
    public final int k;
    public final Set<Long> features = new HashSet<Long>();
    public final Set<Long> negatedFeatures = new HashSet<Long>();

    public IndexableFeatureConjunction(FeatureConjunction conjunction) {
        List operands = conjunction.getOperands();
        int nNegatedFeatureSets = 0;
        for (Predicate operand : operands) {
            if (operand instanceof FeatureSet) {
                IndexableFeatureConjunction.addFeatures((FeatureSet)operand, this.features);
                continue;
            }
            FeatureSet featureSet = (FeatureSet)((Negation)operand).getOperand();
            IndexableFeatureConjunction.addFeatures(featureSet, this.negatedFeatures);
            ++nNegatedFeatureSets;
        }
        this.id = this.calculateConjunctionId();
        this.k = operands.size() - nNegatedFeatureSets;
    }

    private static void addFeatures(FeatureSet featureSet, Set<Long> features) {
        String key = featureSet.getKey();
        featureSet.getValues().forEach(value -> features.add(Feature.createHash(key, value)));
    }

    private long calculateConjunctionId() {
        long posHash = 0L;
        for (long feature : this.features) {
            posHash ^= feature;
        }
        long negHash = 0L;
        for (long feature : this.negatedFeatures) {
            negHash ^= feature;
        }
        return posHash + 3L * negHash | 1L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexableFeatureConjunction that = (IndexableFeatureConjunction)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

