/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.annotator;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureConjunction;
import com.yahoo.document.predicate.FeatureRange;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateHash;
import com.yahoo.document.predicate.RangeEdgePartition;
import com.yahoo.document.predicate.RangePartition;
import com.yahoo.search.predicate.annotator.PredicateTreeAnalyzer;
import com.yahoo.search.predicate.annotator.PredicateTreeAnalyzerResult;
import com.yahoo.search.predicate.annotator.PredicateTreeAnnotations;
import com.yahoo.search.predicate.index.Feature;
import com.yahoo.search.predicate.index.Interval;
import com.yahoo.search.predicate.index.IntervalWithBounds;
import com.yahoo.search.predicate.index.conjunction.IndexableFeatureConjunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PredicateTreeAnnotator {
    private PredicateTreeAnnotator() {
    }

    public static PredicateTreeAnnotations createPredicateTreeAnnotations(Predicate predicate) {
        PredicateTreeAnalyzerResult analyzerResult = PredicateTreeAnalyzer.analyzePredicateTree(predicate);
        int intervalEnd = analyzerResult.treeSize;
        AnnotatorContext context = new AnnotatorContext(intervalEnd, analyzerResult.sizeMap);
        PredicateTreeAnnotator.assignIntervalLabels(predicate, 1, intervalEnd, false, context);
        return new PredicateTreeAnnotations(analyzerResult.minFeature, intervalEnd, context.intervals, context.intervalsWithBounds, context.featureConjunctions);
    }

    private static void assignIntervalLabels(Predicate predicate, int begin, int end, boolean isNegated, AnnotatorContext context) {
        if (predicate instanceof Conjunction) {
            List children = ((Conjunction)predicate).getOperands();
            int current = begin;
            for (int i = 0; i < children.size(); ++i) {
                int next;
                Predicate child = (Predicate)children.get(i);
                int subTreeSize = context.subTreeSizes.get(child);
                if (i == children.size() - 1) {
                    PredicateTreeAnnotator.assignIntervalLabels(child, current, end, isNegated, context);
                    continue;
                }
                if (i == 0) {
                    next = context.leftNodeLeaves + subTreeSize + 1;
                    PredicateTreeAnnotator.assignIntervalLabels(child, current, next - 1, isNegated, context);
                    current = next;
                    continue;
                }
                next = current + subTreeSize;
                PredicateTreeAnnotator.assignIntervalLabels(child, current, next - 1, isNegated, context);
                current = next;
            }
        } else if (predicate instanceof FeatureConjunction) {
            int zStarEnd = isNegated ? PredicateTreeAnnotator.calculateZStarIntervalEnd(end, context) : end;
            IndexableFeatureConjunction indexable = new IndexableFeatureConjunction((FeatureConjunction)predicate);
            int interval = Interval.fromBoundaries(begin, zStarEnd);
            context.featureConjunctions.computeIfAbsent(indexable, k -> new ArrayList()).add(interval);
            if (isNegated) {
                PredicateTreeAnnotator.registerZStarInterval(begin, end, zStarEnd, context);
            }
            ++context.leftNodeLeaves;
        } else if (predicate instanceof Disjunction) {
            for (Predicate child : ((Disjunction)predicate).getOperands()) {
                PredicateTreeAnnotator.assignIntervalLabels(child, begin, end, isNegated, context);
            }
        } else if (predicate instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)predicate;
            int zStarEnd = isNegated ? PredicateTreeAnnotator.calculateZStarIntervalEnd(end, context) : end;
            for (String value : featureSet.getValues()) {
                long featureHash = Feature.createHash(featureSet.getKey(), value);
                int interval = Interval.fromBoundaries(begin, zStarEnd);
                PredicateTreeAnnotator.registerFeatureInterval(featureHash, interval, context.intervals);
            }
            if (isNegated) {
                PredicateTreeAnnotator.registerZStarInterval(begin, end, zStarEnd, context);
            }
            ++context.leftNodeLeaves;
        } else if (predicate instanceof Negation) {
            PredicateTreeAnnotator.assignIntervalLabels(((Negation)predicate).getOperand(), begin, end, !isNegated, context);
        } else if (predicate instanceof FeatureRange) {
            long featureHash;
            FeatureRange featureRange = (FeatureRange)predicate;
            int zStarEnd = isNegated ? PredicateTreeAnnotator.calculateZStarIntervalEnd(end, context) : end;
            int interval = Interval.fromBoundaries(begin, zStarEnd);
            for (RangePartition partition : featureRange.getPartitions()) {
                featureHash = PredicateHash.hash64((String)partition.getLabel());
                PredicateTreeAnnotator.registerFeatureInterval(featureHash, interval, context.intervals);
            }
            for (RangeEdgePartition edgePartition : featureRange.getEdgePartitions()) {
                featureHash = PredicateHash.hash64((String)edgePartition.getLabel());
                IntervalWithBounds intervalWithBounds = new IntervalWithBounds(interval, (int)edgePartition.encodeBounds());
                PredicateTreeAnnotator.registerFeatureInterval(featureHash, intervalWithBounds, context.intervalsWithBounds);
            }
            if (isNegated) {
                PredicateTreeAnnotator.registerZStarInterval(begin, end, zStarEnd, context);
            }
            ++context.leftNodeLeaves;
        } else {
            throw new UnsupportedOperationException("Cannot handle predicate of type " + predicate.getClass().getSimpleName());
        }
    }

    private static void registerZStarInterval(int begin, int end, int zStarIntervalEnd, AnnotatorContext context) {
        int interval = Interval.fromZStar1Boundaries(begin - 1, zStarIntervalEnd);
        PredicateTreeAnnotator.registerFeatureInterval(Feature.Z_STAR_COMPRESSED_ATTRIBUTE_HASH, interval, context.intervals);
        if (end - zStarIntervalEnd != 1) {
            int extraInterval = Interval.fromZStar2Boundaries(end);
            PredicateTreeAnnotator.registerFeatureInterval(Feature.Z_STAR_COMPRESSED_ATTRIBUTE_HASH, extraInterval, context.intervals);
        }
        ++context.leftNodeLeaves;
    }

    private static int calculateZStarIntervalEnd(int end, AnnotatorContext context) {
        if (!context.finalRangeUsed && end == context.intervalEnd) {
            context.finalRangeUsed = true;
            return context.intervalEnd - 1;
        }
        return context.leftNodeLeaves + 1;
    }

    private static <T> void registerFeatureInterval(long featureHash, T interval, Map<Long, List<T>> intervals) {
        intervals.computeIfAbsent(featureHash, k -> new ArrayList()).add(interval);
    }

    private static class AnnotatorContext {
        public final int intervalEnd;
        public final Map<Long, List<Integer>> intervals = new HashMap<Long, List<Integer>>();
        public final Map<Long, List<IntervalWithBounds>> intervalsWithBounds = new HashMap<Long, List<IntervalWithBounds>>();
        public final Map<IndexableFeatureConjunction, List<Integer>> featureConjunctions = new HashMap<IndexableFeatureConjunction, List<Integer>>();
        public final Map<Predicate, Integer> subTreeSizes;
        public int leftNodeLeaves = 0;
        public boolean finalRangeUsed = false;

        public AnnotatorContext(int intervalEnd, Map<Predicate, Integer> subTreeSizes) {
            this.intervalEnd = intervalEnd;
            this.subTreeSizes = subTreeSizes;
        }
    }
}

