/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.benchmarks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.Config;
import com.yahoo.search.predicate.Hit;
import com.yahoo.search.predicate.PredicateIndex;
import com.yahoo.search.predicate.PredicateIndexBuilder;
import com.yahoo.search.predicate.PredicateQuery;
import com.yahoo.search.predicate.serialization.PredicateQuerySerializer;
import com.yahoo.search.predicate.utils.VespaFeedParser;
import com.yahoo.search.predicate.utils.VespaQueryParser;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.SingleCommand;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

public class HitsVerificationBenchmark {
    public static void main(String[] rawArgs) throws IOException {
        Optional<BenchmarkArguments> wrappedArgs = HitsVerificationBenchmark.getArguments(rawArgs);
        if (wrappedArgs.isEmpty()) {
            return;
        }
        BenchmarkArguments args = wrappedArgs.get();
        TreeMap<String, Object> output = new TreeMap<String, Object>();
        HitsVerificationBenchmark.addArgsToOutput(output, args);
        Config config = new Config.Builder().setArity(args.arity).setUseConjunctionAlgorithm(args.algorithm == BenchmarkArguments.Algorithm.CONJUNCTION).build();
        PredicateIndex index = HitsVerificationBenchmark.getIndex(args, config, output);
        Stream<PredicateQuery> queries = HitsVerificationBenchmark.parseQueries(args.format, args.queryFile);
        int totalHits = HitsVerificationBenchmark.runQueries(index, queries, args.outputFile);
        output.put("Total hits", totalHits);
        HitsVerificationBenchmark.writeOutputToStandardOut(output);
    }

    private static PredicateIndex getIndex(BenchmarkArguments args, Config config, Map<String, Object> output) throws IOException {
        if (args.feedFile != null) {
            PredicateIndexBuilder builder = new PredicateIndexBuilder(config);
            AtomicInteger idCounter = new AtomicInteger();
            VespaFeedParser.parseDocuments(args.feedFile, Integer.MAX_VALUE, p -> builder.indexDocument(idCounter.incrementAndGet(), (Predicate)p));
            builder.getStats().putValues(output);
            return builder.build();
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(args.indexFile)));){
            long start = System.currentTimeMillis();
            PredicateIndex index = PredicateIndex.fromInputStream(in);
            output.put("Time deserialize index", System.currentTimeMillis() - start);
            PredicateIndex predicateIndex = index;
            return predicateIndex;
        }
    }

    private static int runQueries(PredicateIndex index, Stream<PredicateQuery> queries, String outputFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, false));){
            AtomicInteger i = new AtomicInteger();
            PredicateIndex.Searcher searcher = index.searcher();
            int n = queries.map(searcher::search).peek(hits -> {
                if (i.get() % 500 == 0) {
                    index.rebuildPostingListCache();
                }
            }).mapToInt(hits -> HitsVerificationBenchmark.writeHits(i.getAndIncrement(), hits, writer)).sum();
            return n;
        }
    }

    private static Stream<PredicateQuery> parseQueries(BenchmarkArguments.Format format, String queryFile) throws IOException {
        PredicateQuerySerializer serializer = new PredicateQuerySerializer();
        return Files.lines(Paths.get(queryFile, new String[0])).map(line -> format == BenchmarkArguments.Format.JSON ? serializer.fromJSON((String)line) : VespaQueryParser.parseQueryFromQueryProperties(line));
    }

    private static int writeHits(int i, Stream<Hit> hitStream, BufferedWriter writer) {
        try {
            List<Hit> hits = hitStream.toList();
            writer.append(Integer.toString(i)).append(": ").append(hits.stream().map(hit -> String.format("(%d, 0x%x)", hit.getDocId(), hit.getSubquery())).collect(Collectors.joining(", ", "[", "]"))).append("\n\n");
            return hits.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<BenchmarkArguments> getArguments(String[] rawArgs) {
        BenchmarkArguments args = (BenchmarkArguments)SingleCommand.singleCommand(BenchmarkArguments.class).parse(rawArgs);
        if (args.helpOption.showHelpIfRequested()) {
            return Optional.empty();
        }
        if (args.feedFile == null && args.indexFile == null) {
            System.err.println("Provide either a feed file or index file.");
            return Optional.empty();
        }
        return Optional.of(args);
    }

    private static void addArgsToOutput(Map<String, Object> output, BenchmarkArguments args) {
        output.put("Arity", args.arity);
        output.put("Algorithm", (Object)args.algorithm);
        output.put("Query format", (Object)args.format);
        output.put("Feed file", args.feedFile);
        output.put("Query file", args.queryFile);
        output.put("Output file", args.outputFile);
        output.put("Index file", args.indexFile);
    }

    private static void writeOutputToStandardOut(Map<String, Object> output) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue((OutputStream)System.out, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Command(name="hits-verifier", description="Java predicate search system test that outputs the returned hits for each query")
    public static class BenchmarkArguments {
        @Option(name={"-a", "--arity"}, description="Arity")
        public int arity = 2;
        @Option(name={"-al", "--algorithm"}, description="Algorithm (CONJUNCTION or INTERVALONLY)")
        public Algorithm algorithm = Algorithm.INTERVALONLY;
        @Option(name={"-qf", "--query-format"}, description="Query format. Valid formats are either 'vespa' (obsolete query property format) or 'json'.")
        public Format format = Format.VESPA;
        @Option(name={"-ff", "--feed-file"}, description="File path to feed file (Vespa XML feed)")
        public String feedFile;
        @Option(name={"-if", "--index-file"}, description="File path to index file (Serialized index)")
        public String indexFile;
        @Option(name={"-quf", "--query-file"}, description="File path to a query file")
        public String queryFile;
        @Arguments(title="Output file", description="File path to output file")
        public String outputFile;
        @Inject
        public HelpOption helpOption;

        public static enum Algorithm {
            CONJUNCTION,
            INTERVALONLY;

        }

        public static enum Format {
            JSON,
            VESPA;

        }
    }
}

