/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.annotator;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureConjunction;
import com.yahoo.document.predicate.FeatureRange;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.predicate.PredicateHash;
import com.yahoo.search.predicate.annotator.PredicateTreeAnalyzerResult;
import com.yahoo.search.predicate.index.Feature;
import com.yahoo.search.predicate.index.conjunction.IndexableFeatureConjunction;
import java.util.HashMap;
import java.util.Map;

public class PredicateTreeAnalyzer {
    public static PredicateTreeAnalyzerResult analyzePredicateTree(Predicate predicate) {
        AnalyzerContext context = new AnalyzerContext();
        int treeSize = PredicateTreeAnalyzer.aggregatePredicateStatistics(predicate, false, context);
        int minFeature = (int)Math.ceil(PredicateTreeAnalyzer.findMinFeature(predicate, false, context)) + (context.hasNegationPredicate ? 1 : 0);
        return new PredicateTreeAnalyzerResult(minFeature, treeSize, context.subTreeSizes);
    }

    private static int aggregatePredicateStatistics(Predicate predicate, boolean isNegated, AnalyzerContext context) {
        if (predicate instanceof Negation) {
            return PredicateTreeAnalyzer.aggregatePredicateStatistics(((Negation)predicate).getOperand(), !isNegated, context);
        }
        if (predicate instanceof Conjunction) {
            return ((Conjunction)predicate).getOperands().stream().mapToInt(child -> {
                int size = PredicateTreeAnalyzer.aggregatePredicateStatistics(child, isNegated, context);
                context.subTreeSizes.put((Predicate)child, size);
                return size;
            }).sum();
        }
        if (predicate instanceof FeatureConjunction) {
            if (isNegated) {
                context.hasNegationPredicate = true;
                return 2;
            }
            IndexableFeatureConjunction ifc = new IndexableFeatureConjunction((FeatureConjunction)predicate);
            PredicateTreeAnalyzer.incrementOccurrence(context.conjunctionOccurrences, ifc.id);
            return 1;
        }
        if (predicate instanceof Disjunction) {
            return ((Disjunction)predicate).getOperands().stream().mapToInt(child -> PredicateTreeAnalyzer.aggregatePredicateStatistics(child, isNegated, context)).sum();
        }
        if (predicate instanceof FeatureSet) {
            if (isNegated) {
                context.hasNegationPredicate = true;
                return 2;
            }
            FeatureSet featureSet = (FeatureSet)predicate;
            for (String value : featureSet.getValues()) {
                PredicateTreeAnalyzer.incrementOccurrence(context.featureOccurrences, Feature.createHash(featureSet.getKey(), value));
            }
            return 1;
        }
        if (predicate instanceof FeatureRange) {
            if (isNegated) {
                context.hasNegationPredicate = true;
                return 2;
            }
            PredicateTreeAnalyzer.incrementOccurrence(context.featureOccurrences, PredicateHash.hash64((String)((FeatureRange)predicate).getKey()));
            return 1;
        }
        throw new UnsupportedOperationException("Cannot handle predicate of type " + predicate.getClass().getSimpleName());
    }

    private static double findMinFeature(Predicate predicate, boolean isNegated, AnalyzerContext context) {
        if (predicate instanceof Conjunction) {
            return ((Conjunction)predicate).getOperands().stream().mapToDouble(child -> PredicateTreeAnalyzer.findMinFeature(child, isNegated, context)).sum();
        }
        if (predicate instanceof FeatureConjunction) {
            if (isNegated) {
                return 0.0;
            }
            IndexableFeatureConjunction ifc = new IndexableFeatureConjunction((FeatureConjunction)predicate);
            return 1.0 / (double)context.conjunctionOccurrences.get(ifc.id).intValue();
        }
        if (predicate instanceof Disjunction) {
            return ((Disjunction)predicate).getOperands().stream().mapToDouble(child -> PredicateTreeAnalyzer.findMinFeature(child, isNegated, context)).min().getAsDouble();
        }
        if (predicate instanceof Negation) {
            return PredicateTreeAnalyzer.findMinFeature(((Negation)predicate).getOperand(), !isNegated, context);
        }
        if (predicate instanceof FeatureSet) {
            if (isNegated) {
                return 0.0;
            }
            double minFeature = 1.0;
            FeatureSet featureSet = (FeatureSet)predicate;
            for (String value : featureSet.getValues()) {
                long featureHash = Feature.createHash(featureSet.getKey(), value);
                minFeature = Math.min(minFeature, 1.0 / (double)context.featureOccurrences.get(featureHash).intValue());
            }
            return minFeature;
        }
        if (predicate instanceof FeatureRange) {
            if (isNegated) {
                return 0.0;
            }
            return 1.0 / (double)context.featureOccurrences.get(PredicateHash.hash64((String)((FeatureRange)predicate).getKey())).intValue();
        }
        throw new UnsupportedOperationException("Cannot handle predicate of type " + predicate.getClass().getSimpleName());
    }

    private static void incrementOccurrence(Map<Long, Integer> featureOccurrences, long featureHash) {
        featureOccurrences.merge(featureHash, 1, Integer::sum);
    }

    private static class AnalyzerContext {
        public final Map<Long, Integer> featureOccurrences = new HashMap<Long, Integer>();
        public final Map<Long, Integer> conjunctionOccurrences = new HashMap<Long, Integer>();
        public final Map<Predicate, Integer> subTreeSizes = new HashMap<Predicate, Integer>();
        public boolean hasNegationPredicate = false;

        private AnalyzerContext() {
        }
    }
}

