/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.benchmarks;

import java.util.Map;

public class ResultMetrics {
    private static final int MAX_LATENCY = 100;
    private static final int RESOLUTION = 25;
    private static final int SLOTS = 2500;
    private long totalQueries = 0L;
    private long totalHits = 0L;
    private double maxLatency = Double.MIN_VALUE;
    private double minLatency = Double.MAX_VALUE;
    private final long[] latencyHistogram = new long[2500];

    public void registerResult(long hits, double latencyMilliseconds) {
        if (latencyMilliseconds > this.maxLatency) {
            this.maxLatency = latencyMilliseconds;
        }
        if (latencyMilliseconds < this.minLatency) {
            this.minLatency = latencyMilliseconds;
        }
        this.totalHits += hits;
        ++this.totalQueries;
        int latencySlot = (int)Math.round(latencyMilliseconds * 25.0);
        if (latencySlot < 2500) {
            int n = latencySlot;
            this.latencyHistogram[n] = this.latencyHistogram[n] + 1L;
        }
    }

    public void combine(ResultMetrics other) {
        this.totalQueries += other.totalQueries;
        this.minLatency = Math.min(this.minLatency, other.minLatency);
        this.maxLatency = Math.max(this.maxLatency, other.maxLatency);
        this.totalHits += other.totalHits;
        for (int i = 0; i < 2500; ++i) {
            int n = i;
            this.latencyHistogram[n] = this.latencyHistogram[n] + other.latencyHistogram[i];
        }
    }

    public void writeMetrics(Map<String, Object> metricMap, long timeSearch) {
        double qps = timeSearch == 0L ? 0.0 : 1000.0 * (double)this.totalQueries / (double)timeSearch;
        metricMap.put("QPS", qps);
        metricMap.put("Time search", timeSearch);
        metricMap.put("Total hits", this.totalHits);
        metricMap.put("Total queries", this.totalQueries);
        metricMap.put("Max latency", ResultMetrics.latencyToString(this.maxLatency));
        metricMap.put("Min latency", ResultMetrics.latencyToString(this.minLatency));
        metricMap.put("99.9 percentile", ResultMetrics.latencyToString(this.percentile(0.999)));
        metricMap.put("99 percentile", ResultMetrics.latencyToString(this.percentile(0.99)));
        metricMap.put("90 percentile", ResultMetrics.latencyToString(this.percentile(0.9)));
        metricMap.put("75 percentile", ResultMetrics.latencyToString(this.percentile(0.75)));
        metricMap.put("50 percentile", ResultMetrics.latencyToString(this.percentile(0.5)));
    }

    private double percentile(double percentile) {
        int index;
        int targetCount = (int)Math.round((double)this.totalQueries * percentile);
        int currentCount = 0;
        for (index = 0; currentCount < targetCount && index < 2500; ++index) {
            currentCount = (int)((long)currentCount + this.latencyHistogram[index]);
        }
        if (index == 2500) {
            return this.maxLatency;
        }
        return ResultMetrics.toLatency(currentCount == targetCount ? index + 1 : index);
    }

    private static String latencyToString(double averageLatency) {
        return String.format("%.2fms", averageLatency);
    }

    private static double toLatency(int index) {
        return ((double)index + 0.5) / 25.0;
    }
}

