/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.optimization;

import com.yahoo.document.predicate.Conjunction;
import com.yahoo.document.predicate.Disjunction;
import com.yahoo.document.predicate.FeatureConjunction;
import com.yahoo.document.predicate.FeatureSet;
import com.yahoo.document.predicate.Negation;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.search.predicate.optimization.PredicateOptions;
import com.yahoo.search.predicate.optimization.PredicateProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FeatureConjunctionTransformer
implements PredicateProcessor {
    private static final int CONVERSION_THRESHOLD = Integer.MAX_VALUE;
    private final boolean useConjunctionAlgorithm;

    public FeatureConjunctionTransformer(boolean useConjunctionAlgorithm) {
        this.useConjunctionAlgorithm = useConjunctionAlgorithm;
    }

    public Predicate process(Predicate predicate, PredicateOptions options) {
        if (this.useConjunctionAlgorithm) {
            return FeatureConjunctionTransformer.transform(predicate);
        }
        return predicate;
    }

    private static Predicate transform(Predicate predicate) {
        if (predicate instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)predicate;
            conjunction.getOperands().replaceAll(FeatureConjunctionTransformer::transform);
            long nValidOperands = FeatureConjunctionTransformer.numberOfValidFeatureSetOperands(conjunction);
            if (nValidOperands > 1L && nValidOperands <= Integer.MAX_VALUE) {
                return FeatureConjunctionTransformer.convertConjunction(conjunction, nValidOperands);
            }
        } else if (predicate instanceof Disjunction) {
            ((Disjunction)predicate).getOperands().replaceAll(FeatureConjunctionTransformer::transform);
        } else if (predicate instanceof Negation) {
            Negation negation = (Negation)predicate;
            negation.setOperand(FeatureConjunctionTransformer.transform(negation.getOperand()));
        }
        return predicate;
    }

    private static Predicate convertConjunction(Conjunction conjunction, long nValidOperands) {
        List operands = conjunction.getOperands();
        if (nValidOperands == (long)operands.size()) {
            return new FeatureConjunction(operands);
        }
        ArrayList<Predicate> invalidFeatureConjunctionOperands = new ArrayList<Predicate>();
        ArrayList<Map<String, Predicate>> featureConjunctionOperandsList = new ArrayList<Map<String, Predicate>>();
        featureConjunctionOperandsList.add(new TreeMap());
        for (Predicate operand : operands) {
            if (FeatureConjunction.isValidFeatureConjunctionOperand((Predicate)operand)) {
                FeatureConjunctionTransformer.addFeatureConjunctionOperand(featureConjunctionOperandsList, operand);
                continue;
            }
            invalidFeatureConjunctionOperands.add(operand);
        }
        Conjunction newConjunction = new Conjunction(new Predicate[0]);
        newConjunction.addOperands(invalidFeatureConjunctionOperands);
        for (Map map : featureConjunctionOperandsList) {
            Collection values = map.values();
            if (map.size() == 1) {
                newConjunction.addOperands(values);
                continue;
            }
            newConjunction.addOperand((Predicate)new FeatureConjunction(new ArrayList(values)));
        }
        return newConjunction;
    }

    private static void addFeatureConjunctionOperand(List<Map<String, Predicate>> featureConjunctionOperandsList, Predicate operand) {
        String key = FeatureConjunctionTransformer.getFeatureSetKey(operand);
        for (Map<String, Predicate> featureConjunctionOperands : featureConjunctionOperandsList) {
            if (featureConjunctionOperands.containsKey(key)) continue;
            featureConjunctionOperands.put(key, operand);
            return;
        }
        TreeMap<String, Predicate> conjunctionOperands = new TreeMap<String, Predicate>();
        conjunctionOperands.put(key, operand);
        featureConjunctionOperandsList.add(conjunctionOperands);
    }

    private static long numberOfValidFeatureSetOperands(Conjunction conjunction) {
        return conjunction.getOperands().stream().filter(FeatureConjunction::isValidFeatureConjunctionOperand).map(FeatureConjunctionTransformer::getFeatureSetKey).distinct().count();
    }

    private static String getFeatureSetKey(Predicate predicate) {
        if (predicate instanceof FeatureSet) {
            return ((FeatureSet)predicate).getKey();
        }
        Negation negation = (Negation)predicate;
        return ((FeatureSet)negation.getOperand()).getKey();
    }
}

