/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.predicate.utils;

import com.yahoo.search.predicate.PredicateQuery;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class VespaQueryParser {
    public static List<PredicateQuery> parseQueries(String queryFile, int maxQueryCount) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(queryFile), 8192);){
            List<PredicateQuery> queries;
            List<PredicateQuery> list = queries = reader.lines().limit(maxQueryCount).map(VespaQueryParser::parseQueryFromQueryProperties).collect(Collectors.toList());
            return list;
        }
    }

    public static PredicateQuery parseQueryFromQueryProperties(String queryString) {
        try {
            queryString = URLDecoder.decode(queryString, "UTF-8");
            PredicateQuery query = new PredicateQuery();
            VespaQueryParser.extractQueryValues(queryString, "boolean.attributes", query::addFeature);
            VespaQueryParser.extractQueryValues(queryString, "boolean.rangeAttributes", (k, v) -> query.addRangeFeature((String)k, Integer.parseInt(v)));
            return query;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static void extractQueryValues(String query, String prefix, BiConsumer<String, String> registerTerm) {
        int rangeIndex = query.indexOf(prefix);
        if (rangeIndex != -1) {
            String[] keyValuePairs;
            int startIndex = rangeIndex + prefix.length() + 2;
            int endIndex = query.indexOf("}", startIndex);
            String rangeString = query.substring(startIndex, endIndex);
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (String keyValuePair : keyValuePairs = rangeString.split(",")) {
                String[] keyAndValue = keyValuePair.split(":");
                if (keyAndValue.length == 1) {
                    Feature feature = (Feature)features.get(features.size() - 1);
                    feature.value = feature.value + "," + keyValuePair;
                    continue;
                }
                features.add(new Feature(keyAndValue[0], keyAndValue[1]));
            }
            features.stream().forEach(f -> registerTerm.accept(f.key, f.value));
        }
    }

    private static class Feature {
        public final String key;
        public String value;

        private Feature(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Feature feature = (Feature)o;
            if (!this.key.equals(feature.key)) {
                return false;
            }
            return this.value.equals(feature.value);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }
    }
}

