/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.configmodelview;

import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.configmodelview.MlModelImporter;
import com.yahoo.path.Path;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public class ImportedMlModels {
    private final Map<String, ImportedMlModel> importedModels;
    private final Map<String, String> skippedModels = new ConcurrentHashMap<String, String>();

    public ImportedMlModels() {
        this.importedModels = Map.of();
    }

    public ImportedMlModels(File modelsDirectory, ExecutorService executor, Collection<MlModelImporter> importers) {
        HashMap<String, Future<ImportedMlModel>> futureModels = new HashMap<String, Future<ImportedMlModel>>();
        ImportedMlModels.importRecursively(modelsDirectory, executor, futureModels, importers, this.skippedModels);
        HashMap models = new HashMap();
        futureModels.forEach((name, future) -> {
            try {
                ImportedMlModel model = (ImportedMlModel)future.get();
                if (model != null) {
                    models.put(name, model);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                this.skippedModels.put((String)name, Exceptions.toMessageString((Throwable)e));
            }
        });
        this.importedModels = Map.copyOf(models);
    }

    public ImportedMlModel get(File modelPath) {
        return this.importedModels.get(ImportedMlModels.toName(modelPath));
    }

    public Collection<ImportedMlModel> all() {
        return this.importedModels.values();
    }

    public Map<String, String> getSkippedModels() {
        return this.skippedModels;
    }

    private static void importRecursively(File dir, ExecutorService executor, Map<String, Future<ImportedMlModel>> models, Collection<MlModelImporter> importers, Map<String, String> skippedModels) {
        if (!dir.isDirectory()) {
            return;
        }
        Arrays.stream(dir.listFiles()).sorted().forEach(child -> {
            Optional<MlModelImporter> importer = ImportedMlModels.findImporterOf(child, importers);
            if (importer.isPresent()) {
                ImportedMlModels.validateModelPath(child);
                String name = ImportedMlModels.toName(child);
                Future existing = (Future)models.get(name);
                if (existing != null) {
                    try {
                        throw new IllegalArgumentException("The models in " + String.valueOf(child) + " and " + ((ImportedMlModel)existing.get()).source() + " both resolve to the model name '" + name + "'");
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
                Future<ImportedMlModel> future = executor.submit(() -> {
                    try {
                        return ((MlModelImporter)importer.get()).importModel(name, (File)child);
                    }
                    catch (RuntimeException e) {
                        skippedModels.put(name, e.getMessage());
                        return null;
                    }
                });
                models.put(name, future);
            } else {
                ImportedMlModels.importRecursively(child, executor, models, importers, skippedModels);
            }
        });
    }

    private static Optional<MlModelImporter> findImporterOf(File path, Collection<MlModelImporter> importers) {
        return importers.stream().filter(item -> item.canImport(path.toString())).findFirst();
    }

    private static String toName(File modelFile) {
        Path modelPath = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            modelPath = ImportedMlModels.stripFileEnding(modelPath);
        }
        String localPath = ImportedMlModels.concatenateAfterModelsDirectory(modelPath);
        return localPath.replace('.', '_');
    }

    private static Path stripFileEnding(Path path) {
        int dotIndex = path.last().lastIndexOf(".");
        if (dotIndex <= 0) {
            return path;
        }
        return path.withLast(path.last().substring(0, dotIndex));
    }

    private static String concatenateAfterModelsDirectory(Path path) {
        boolean afterModels = false;
        StringBuilder result = new StringBuilder();
        for (String element : path.elements()) {
            if (afterModels) {
                result.append(element).append("_");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
        return result.substring(0, result.length() - 1);
    }

    private static void validateModelPath(File modelFile) {
        Pattern nameRegexp = Pattern.compile("[A-Za-z0-9_.]*");
        Path path = Path.fromString((String)modelFile.toString());
        if (modelFile.isFile()) {
            path = ImportedMlModels.stripFileEnding(path);
        }
        boolean afterModels = false;
        for (String element : path.elements()) {
            if (afterModels) {
                if (nameRegexp.matcher(element).matches()) continue;
                throw new IllegalArgumentException("When Vespa imports a model from the 'models' directory, it uses the directory structure under 'models' to determine the name of the model. The directory or file name '" + element + "' is not valid. Please rename this to only contain letters, numbers or underscores.");
            }
            if (!element.equals("models")) continue;
            afterModels = true;
        }
    }
}

