/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.generation;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class OnnxEncoderDecoderTextGeneratorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "07a9e0d3909d99f4563217f1f0db98aa";
    public static final String CONFIG_DEF_NAME = "onnx-encoder-decoder-text-generator";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.generation";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.generation", "tokenizerModel model", "tokenizerMaxTokens int default=1000", "encoderModel model", "encoderModelInputIdsName string default=input_ids", "encoderModelAttentionMaskName string default=attention_mask", "encoderModelOutputName string default=last_hidden_state", "encoderOnnxExecutionMode enum { parallel, sequential } default=sequential", "encoderOnnxInterOpThreads int default=1", "encoderOnnxIntraOpThreads int default=-4", "decoderModel model", "decoderModelInputIdsName string default=input_ids", "decoderModelAttentionMaskName string default=encoder_attention_mask", "decoderModelEncoderHiddenStateName string default=encoder_hidden_states", "decoderModelOutputName string default=logits", "decoderOnnxExecutionMode enum { parallel, sequential } default=sequential", "decoderOnnxInterOpThreads int default=1", "decoderOnnxIntraOpThreads int default=-4"};
    private final ModelNode tokenizerModel;
    private final IntegerNode tokenizerMaxTokens;
    private final ModelNode encoderModel;
    private final StringNode encoderModelInputIdsName;
    private final StringNode encoderModelAttentionMaskName;
    private final StringNode encoderModelOutputName;
    private final EncoderOnnxExecutionMode encoderOnnxExecutionMode;
    private final IntegerNode encoderOnnxInterOpThreads;
    private final IntegerNode encoderOnnxIntraOpThreads;
    private final ModelNode decoderModel;
    private final StringNode decoderModelInputIdsName;
    private final StringNode decoderModelAttentionMaskName;
    private final StringNode decoderModelEncoderHiddenStateName;
    private final StringNode decoderModelOutputName;
    private final DecoderOnnxExecutionMode decoderOnnxExecutionMode;
    private final IntegerNode decoderOnnxInterOpThreads;
    private final IntegerNode decoderOnnxIntraOpThreads;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OnnxEncoderDecoderTextGeneratorConfig(Builder builder) {
        this(builder, true);
    }

    private OnnxEncoderDecoderTextGeneratorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for onnx-encoder-decoder-text-generator must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.tokenizerModel = builder.tokenizerModel == null ? new ModelNode() : new ModelNode(builder.tokenizerModel);
        this.tokenizerMaxTokens = builder.tokenizerMaxTokens == null ? new IntegerNode(1000) : new IntegerNode(builder.tokenizerMaxTokens.intValue());
        this.encoderModel = builder.encoderModel == null ? new ModelNode() : new ModelNode(builder.encoderModel);
        this.encoderModelInputIdsName = builder.encoderModelInputIdsName == null ? new StringNode("input_ids") : new StringNode(builder.encoderModelInputIdsName);
        this.encoderModelAttentionMaskName = builder.encoderModelAttentionMaskName == null ? new StringNode("attention_mask") : new StringNode(builder.encoderModelAttentionMaskName);
        this.encoderModelOutputName = builder.encoderModelOutputName == null ? new StringNode("last_hidden_state") : new StringNode(builder.encoderModelOutputName);
        this.encoderOnnxExecutionMode = builder.encoderOnnxExecutionMode == null ? new EncoderOnnxExecutionMode(EncoderOnnxExecutionMode.sequential) : new EncoderOnnxExecutionMode(builder.encoderOnnxExecutionMode);
        this.encoderOnnxInterOpThreads = builder.encoderOnnxInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.encoderOnnxInterOpThreads.intValue());
        this.encoderOnnxIntraOpThreads = builder.encoderOnnxIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.encoderOnnxIntraOpThreads.intValue());
        this.decoderModel = builder.decoderModel == null ? new ModelNode() : new ModelNode(builder.decoderModel);
        this.decoderModelInputIdsName = builder.decoderModelInputIdsName == null ? new StringNode("input_ids") : new StringNode(builder.decoderModelInputIdsName);
        this.decoderModelAttentionMaskName = builder.decoderModelAttentionMaskName == null ? new StringNode("encoder_attention_mask") : new StringNode(builder.decoderModelAttentionMaskName);
        this.decoderModelEncoderHiddenStateName = builder.decoderModelEncoderHiddenStateName == null ? new StringNode("encoder_hidden_states") : new StringNode(builder.decoderModelEncoderHiddenStateName);
        this.decoderModelOutputName = builder.decoderModelOutputName == null ? new StringNode("logits") : new StringNode(builder.decoderModelOutputName);
        this.decoderOnnxExecutionMode = builder.decoderOnnxExecutionMode == null ? new DecoderOnnxExecutionMode(DecoderOnnxExecutionMode.sequential) : new DecoderOnnxExecutionMode(builder.decoderOnnxExecutionMode);
        this.decoderOnnxInterOpThreads = builder.decoderOnnxInterOpThreads == null ? new IntegerNode(1) : new IntegerNode(builder.decoderOnnxInterOpThreads.intValue());
        this.decoderOnnxIntraOpThreads = builder.decoderOnnxIntraOpThreads == null ? new IntegerNode(-4) : new IntegerNode(builder.decoderOnnxIntraOpThreads.intValue());
    }

    public Path tokenizerModel() {
        return (Path)this.tokenizerModel.value();
    }

    public int tokenizerMaxTokens() {
        return this.tokenizerMaxTokens.value();
    }

    public Path encoderModel() {
        return (Path)this.encoderModel.value();
    }

    public String encoderModelInputIdsName() {
        return this.encoderModelInputIdsName.value();
    }

    public String encoderModelAttentionMaskName() {
        return this.encoderModelAttentionMaskName.value();
    }

    public String encoderModelOutputName() {
        return this.encoderModelOutputName.value();
    }

    public EncoderOnnxExecutionMode.Enum encoderOnnxExecutionMode() {
        return (EncoderOnnxExecutionMode.Enum)((Object)this.encoderOnnxExecutionMode.value());
    }

    public int encoderOnnxInterOpThreads() {
        return this.encoderOnnxInterOpThreads.value();
    }

    public int encoderOnnxIntraOpThreads() {
        return this.encoderOnnxIntraOpThreads.value();
    }

    public Path decoderModel() {
        return (Path)this.decoderModel.value();
    }

    public String decoderModelInputIdsName() {
        return this.decoderModelInputIdsName.value();
    }

    public String decoderModelAttentionMaskName() {
        return this.decoderModelAttentionMaskName.value();
    }

    public String decoderModelEncoderHiddenStateName() {
        return this.decoderModelEncoderHiddenStateName.value();
    }

    public String decoderModelOutputName() {
        return this.decoderModelOutputName.value();
    }

    public DecoderOnnxExecutionMode.Enum decoderOnnxExecutionMode() {
        return (DecoderOnnxExecutionMode.Enum)((Object)this.decoderOnnxExecutionMode.value());
    }

    public int decoderOnnxInterOpThreads() {
        return this.decoderOnnxInterOpThreads.value();
    }

    public int decoderOnnxIntraOpThreads() {
        return this.decoderOnnxIntraOpThreads.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OnnxEncoderDecoderTextGeneratorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("tokenizerModel", "encoderModel", "decoderModel"));
        private ModelReference tokenizerModel = null;
        private Integer tokenizerMaxTokens = null;
        private ModelReference encoderModel = null;
        private String encoderModelInputIdsName = null;
        private String encoderModelAttentionMaskName = null;
        private String encoderModelOutputName = null;
        private EncoderOnnxExecutionMode.Enum encoderOnnxExecutionMode = null;
        private Integer encoderOnnxInterOpThreads = null;
        private Integer encoderOnnxIntraOpThreads = null;
        private ModelReference decoderModel = null;
        private String decoderModelInputIdsName = null;
        private String decoderModelAttentionMaskName = null;
        private String decoderModelEncoderHiddenStateName = null;
        private String decoderModelOutputName = null;
        private DecoderOnnxExecutionMode.Enum decoderOnnxExecutionMode = null;
        private Integer decoderOnnxInterOpThreads = null;
        private Integer decoderOnnxIntraOpThreads = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OnnxEncoderDecoderTextGeneratorConfig config) {
            this.tokenizerModel(config.tokenizerModel.getModelReference());
            this.tokenizerMaxTokens(config.tokenizerMaxTokens());
            this.encoderModel(config.encoderModel.getModelReference());
            this.encoderModelInputIdsName(config.encoderModelInputIdsName());
            this.encoderModelAttentionMaskName(config.encoderModelAttentionMaskName());
            this.encoderModelOutputName(config.encoderModelOutputName());
            this.encoderOnnxExecutionMode(config.encoderOnnxExecutionMode());
            this.encoderOnnxInterOpThreads(config.encoderOnnxInterOpThreads());
            this.encoderOnnxIntraOpThreads(config.encoderOnnxIntraOpThreads());
            this.decoderModel(config.decoderModel.getModelReference());
            this.decoderModelInputIdsName(config.decoderModelInputIdsName());
            this.decoderModelAttentionMaskName(config.decoderModelAttentionMaskName());
            this.decoderModelEncoderHiddenStateName(config.decoderModelEncoderHiddenStateName());
            this.decoderModelOutputName(config.decoderModelOutputName());
            this.decoderOnnxExecutionMode(config.decoderOnnxExecutionMode());
            this.decoderOnnxInterOpThreads(config.decoderOnnxInterOpThreads());
            this.decoderOnnxIntraOpThreads(config.decoderOnnxIntraOpThreads());
        }

        private Builder override(Builder __superior) {
            if (__superior.tokenizerModel != null) {
                this.tokenizerModel(__superior.tokenizerModel);
            }
            if (__superior.tokenizerMaxTokens != null) {
                this.tokenizerMaxTokens(__superior.tokenizerMaxTokens);
            }
            if (__superior.encoderModel != null) {
                this.encoderModel(__superior.encoderModel);
            }
            if (__superior.encoderModelInputIdsName != null) {
                this.encoderModelInputIdsName(__superior.encoderModelInputIdsName);
            }
            if (__superior.encoderModelAttentionMaskName != null) {
                this.encoderModelAttentionMaskName(__superior.encoderModelAttentionMaskName);
            }
            if (__superior.encoderModelOutputName != null) {
                this.encoderModelOutputName(__superior.encoderModelOutputName);
            }
            if (__superior.encoderOnnxExecutionMode != null) {
                this.encoderOnnxExecutionMode(__superior.encoderOnnxExecutionMode);
            }
            if (__superior.encoderOnnxInterOpThreads != null) {
                this.encoderOnnxInterOpThreads(__superior.encoderOnnxInterOpThreads);
            }
            if (__superior.encoderOnnxIntraOpThreads != null) {
                this.encoderOnnxIntraOpThreads(__superior.encoderOnnxIntraOpThreads);
            }
            if (__superior.decoderModel != null) {
                this.decoderModel(__superior.decoderModel);
            }
            if (__superior.decoderModelInputIdsName != null) {
                this.decoderModelInputIdsName(__superior.decoderModelInputIdsName);
            }
            if (__superior.decoderModelAttentionMaskName != null) {
                this.decoderModelAttentionMaskName(__superior.decoderModelAttentionMaskName);
            }
            if (__superior.decoderModelEncoderHiddenStateName != null) {
                this.decoderModelEncoderHiddenStateName(__superior.decoderModelEncoderHiddenStateName);
            }
            if (__superior.decoderModelOutputName != null) {
                this.decoderModelOutputName(__superior.decoderModelOutputName);
            }
            if (__superior.decoderOnnxExecutionMode != null) {
                this.decoderOnnxExecutionMode(__superior.decoderOnnxExecutionMode);
            }
            if (__superior.decoderOnnxInterOpThreads != null) {
                this.decoderOnnxInterOpThreads(__superior.decoderOnnxInterOpThreads);
            }
            if (__superior.decoderOnnxIntraOpThreads != null) {
                this.decoderOnnxIntraOpThreads(__superior.decoderOnnxIntraOpThreads);
            }
            return this;
        }

        public Builder tokenizerModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tokenizerModel = __value;
            this.__uninitialized.remove("tokenizerModel");
            return this;
        }

        public Builder tokenizerMaxTokens(int __value) {
            this.tokenizerMaxTokens = __value;
            return this;
        }

        private Builder tokenizerMaxTokens(String __value) {
            return this.tokenizerMaxTokens(Integer.valueOf(__value));
        }

        public Builder encoderModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.encoderModel = __value;
            this.__uninitialized.remove("encoderModel");
            return this;
        }

        public Builder encoderModelInputIdsName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.encoderModelInputIdsName = __value;
            return this;
        }

        public Builder encoderModelAttentionMaskName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.encoderModelAttentionMaskName = __value;
            return this;
        }

        public Builder encoderModelOutputName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.encoderModelOutputName = __value;
            return this;
        }

        public Builder encoderOnnxExecutionMode(EncoderOnnxExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.encoderOnnxExecutionMode = __value;
            return this;
        }

        private Builder encoderOnnxExecutionMode(String __value) {
            return this.encoderOnnxExecutionMode(EncoderOnnxExecutionMode.Enum.valueOf(__value));
        }

        public Builder encoderOnnxInterOpThreads(int __value) {
            this.encoderOnnxInterOpThreads = __value;
            return this;
        }

        private Builder encoderOnnxInterOpThreads(String __value) {
            return this.encoderOnnxInterOpThreads(Integer.valueOf(__value));
        }

        public Builder encoderOnnxIntraOpThreads(int __value) {
            this.encoderOnnxIntraOpThreads = __value;
            return this;
        }

        private Builder encoderOnnxIntraOpThreads(String __value) {
            return this.encoderOnnxIntraOpThreads(Integer.valueOf(__value));
        }

        public Builder decoderModel(ModelReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderModel = __value;
            this.__uninitialized.remove("decoderModel");
            return this;
        }

        public Builder decoderModelInputIdsName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderModelInputIdsName = __value;
            return this;
        }

        public Builder decoderModelAttentionMaskName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderModelAttentionMaskName = __value;
            return this;
        }

        public Builder decoderModelEncoderHiddenStateName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderModelEncoderHiddenStateName = __value;
            return this;
        }

        public Builder decoderModelOutputName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderModelOutputName = __value;
            return this;
        }

        public Builder decoderOnnxExecutionMode(DecoderOnnxExecutionMode.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.decoderOnnxExecutionMode = __value;
            return this;
        }

        private Builder decoderOnnxExecutionMode(String __value) {
            return this.decoderOnnxExecutionMode(DecoderOnnxExecutionMode.Enum.valueOf(__value));
        }

        public Builder decoderOnnxInterOpThreads(int __value) {
            this.decoderOnnxInterOpThreads = __value;
            return this;
        }

        private Builder decoderOnnxInterOpThreads(String __value) {
            return this.decoderOnnxInterOpThreads(Integer.valueOf(__value));
        }

        public Builder decoderOnnxIntraOpThreads(int __value) {
            this.decoderOnnxIntraOpThreads = __value;
            return this;
        }

        private Builder decoderOnnxIntraOpThreads(String __value) {
            return this.decoderOnnxIntraOpThreads(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OnnxEncoderDecoderTextGeneratorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OnnxEncoderDecoderTextGeneratorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OnnxEncoderDecoderTextGeneratorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OnnxEncoderDecoderTextGeneratorConfig build() {
            return new OnnxEncoderDecoderTextGeneratorConfig(this);
        }
    }

    public static final class EncoderOnnxExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public EncoderOnnxExecutionMode() {
            this.value = null;
        }

        public EncoderOnnxExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static final class DecoderOnnxExecutionMode
    extends EnumNode<Enum> {
        public static final Enum parallel = Enum.parallel;
        public static final Enum sequential = Enum.sequential;

        public DecoderOnnxExecutionMode() {
            this.value = null;
        }

        public DecoderOnnxExecutionMode(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            parallel,
            sequential;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

