/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.generation;

import ai.vespa.llm.LanguageModel;
import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class LanguageModelUtils {
    public static LanguageModel findLanguageModel(String providerId, ComponentRegistry<LanguageModel> languageModels, Logger log) throws IllegalArgumentException {
        if (languageModels.allComponents().isEmpty()) {
            throw new IllegalArgumentException("No language models were found");
        }
        if (providerId == null || providerId.isEmpty()) {
            Optional entry = languageModels.allComponentsById().entrySet().stream().findFirst();
            if (entry.isEmpty()) {
                throw new IllegalArgumentException("No language models were found");
            }
            log.info("Language model provider was not found in config. Fallback to using first available language model: " + String.valueOf(((Map.Entry)entry.get()).getKey()));
            return (LanguageModel)((Map.Entry)entry.get()).getValue();
        }
        LanguageModel languageModel = (LanguageModel)languageModels.getComponent(providerId);
        if (languageModel == null) {
            throw new IllegalArgumentException("No component with id '" + providerId + "' was found. Available LLM components are: " + languageModels.allComponentsById().keySet().stream().map(ComponentId::toString).collect(Collectors.joining(",")));
        }
        return languageModel;
    }
}

