/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llm.generation;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.OptionalPathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class LanguageModelTextGeneratorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "1b5399046ff7e982270709398bb9702d";
    public static final String CONFIG_DEF_NAME = "language-model-text-generator";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.llm.generation";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.llm.generation", "providerId string", "promptTemplate string default=\"\"", "promptTemplateFile path optional", "maxLength int default=-1"};
    private final StringNode providerId;
    private final StringNode promptTemplate;
    private final OptionalPathNode promptTemplateFile;
    private final IntegerNode maxLength;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LanguageModelTextGeneratorConfig(Builder builder) {
        this(builder, true);
    }

    private LanguageModelTextGeneratorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for language-model-text-generator must be initialized: " + builder.__uninitialized);
        }
        this.providerId = builder.providerId == null ? new StringNode() : new StringNode(builder.providerId);
        this.promptTemplate = builder.promptTemplate == null ? new StringNode("") : new StringNode(builder.promptTemplate);
        this.promptTemplateFile = builder.promptTemplateFile == null ? new OptionalPathNode() : new OptionalPathNode(builder.promptTemplateFile);
        this.maxLength = builder.maxLength == null ? new IntegerNode(-1) : new IntegerNode(builder.maxLength.intValue());
    }

    public String providerId() {
        return this.providerId.value();
    }

    public String promptTemplate() {
        return this.promptTemplate.value();
    }

    public Optional<Path> promptTemplateFile() {
        return this.promptTemplateFile.value();
    }

    public int maxLength() {
        return this.maxLength.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LanguageModelTextGeneratorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("providerId"));
        private String providerId = null;
        private String promptTemplate = null;
        private Optional<FileReference> promptTemplateFile = Optional.empty();
        private Integer maxLength = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LanguageModelTextGeneratorConfig config) {
            this.providerId(config.providerId());
            this.promptTemplate(config.promptTemplate());
            this.promptTemplateFile(config.promptTemplateFile.getFileReference());
            this.maxLength(config.maxLength());
        }

        private Builder override(Builder __superior) {
            if (__superior.providerId != null) {
                this.providerId(__superior.providerId);
            }
            if (__superior.promptTemplate != null) {
                this.promptTemplate(__superior.promptTemplate);
            }
            if (__superior.promptTemplateFile != null) {
                this.promptTemplateFile(__superior.promptTemplateFile);
            }
            if (__superior.maxLength != null) {
                this.maxLength(__superior.maxLength);
            }
            return this;
        }

        public Builder providerId(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.providerId = __value;
            this.__uninitialized.remove("providerId");
            return this;
        }

        public Builder promptTemplate(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.promptTemplate = __value;
            return this;
        }

        public Builder promptTemplateFile(Optional<FileReference> __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.promptTemplateFile = __value;
            this.__uninitialized.remove("promptTemplateFile");
            return this;
        }

        private Builder promptTemplateFile(FileReference __value) {
            return this.promptTemplateFile(Optional.of(__value));
        }

        public Builder maxLength(int __value) {
            this.maxLength = __value;
            return this;
        }

        private Builder maxLength(String __value) {
            return this.maxLength(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LanguageModelTextGeneratorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LanguageModelTextGeneratorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LanguageModelTextGeneratorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LanguageModelTextGeneratorConfig build() {
            return new LanguageModelTextGeneratorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

