/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.vespa;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.configmodelview.ImportedMlModel;
import ai.vespa.rankingexpression.importer.vespa.parser.ModelParser;
import ai.vespa.rankingexpression.importer.vespa.parser.ParseException;
import ai.vespa.rankingexpression.importer.vespa.parser.SimpleCharStream;
import com.yahoo.io.IOUtils;
import java.io.File;
import java.io.IOException;

public class VespaImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".model");
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try {
            ImportedModel model = new ImportedModel(modelName, modelPath, ImportedMlModel.ModelType.VESPA);
            new ModelParser(new SimpleCharStream(IOUtils.readFile((File)new File(modelPath))), model).model();
            return model;
        }
        catch (ParseException | IOException e) {
            throw new IllegalArgumentException("Could not import a Vespa model from '" + modelPath + "'", e);
        }
    }
}

