/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public final class Constant
extends IntermediateOperation {
    public Constant(String modelName, String nodeName, OrderedTensorType type) {
        super(modelName, nodeName, List.of());
        this.type = type.rename(this.vespaName() + "_");
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    protected TensorFunction<Reference> lazyGetFunction() {
        return null;
    }

    @Override
    public Optional<Value> getConstantValue() {
        return Optional.ofNullable(this.constantValueFunction).map(func -> (Value)func.apply(this.type));
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public Constant withInputs(List<IntermediateOperation> inputs) {
        if (!inputs.isEmpty()) {
            throw new IllegalArgumentException("Constant cannot take inputs");
        }
        Constant constant = new Constant(this.modelName(), this.name(), this.type);
        constant.setConstantValueFunction(this.constantValueFunction);
        return constant;
    }

    @Override
    public String operationName() {
        return "Constant";
    }

    @Override
    public String toString() {
        return "Constant(" + this.type + ")";
    }

    @Override
    public String toFullString() {
        return "\t" + this.type + ":\tConstant(" + this.type + ")";
    }
}

