/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding.huggingface;

import java.util.Optional;
import java.util.OptionalInt;

public class HuggingFaceTokenizerOptions {
    private final Boolean addSpecialToken;
    private final Boolean truncation;
    private final boolean truncateFirstOnly;
    private final boolean truncateSecondOnly;
    private final Boolean padding;
    private final boolean padToMaxLength;
    private final Integer maxLength;
    private final Integer padToMultipleOf;
    private final Integer stride;

    private HuggingFaceTokenizerOptions(Builder b) {
        this.addSpecialToken = b.addSpecialToken;
        this.truncation = b.truncation;
        this.truncateFirstOnly = b.truncateFirstOnly;
        this.truncateSecondOnly = b.truncateSecondOnly;
        this.padding = b.padding;
        this.padToMaxLength = b.padToMaxLength;
        this.maxLength = b.maxLength;
        this.padToMultipleOf = b.padToMultipleOf;
        this.stride = b.stride;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static HuggingFaceTokenizerOptions defaults() {
        return new Builder().build();
    }

    Optional<Boolean> addSpecialToken() {
        return Optional.ofNullable(this.addSpecialToken);
    }

    Optional<Boolean> truncation() {
        return Optional.ofNullable(this.truncation);
    }

    boolean truncateFirstOnly() {
        return this.truncateFirstOnly;
    }

    boolean truncateSecondOnly() {
        return this.truncateSecondOnly;
    }

    Optional<Boolean> padding() {
        return Optional.ofNullable(this.padding);
    }

    boolean padToMaxLength() {
        return this.padToMaxLength;
    }

    OptionalInt maxLength() {
        return this.maxLength != null ? OptionalInt.of(this.maxLength) : OptionalInt.empty();
    }

    OptionalInt padToMultipleOf() {
        return this.padToMultipleOf != null ? OptionalInt.of(this.padToMultipleOf) : OptionalInt.empty();
    }

    OptionalInt stride() {
        return this.stride != null ? OptionalInt.of(this.stride) : OptionalInt.empty();
    }

    public static class Builder {
        private Boolean addSpecialToken;
        private Boolean truncation;
        private boolean truncateFirstOnly;
        private boolean truncateSecondOnly;
        private Boolean padding;
        private boolean padToMaxLength;
        private Integer maxLength;
        private Integer padToMultipleOf;
        private Integer stride;

        public Builder addSpecialToken(boolean enabled) {
            this.addSpecialToken = enabled;
            return this;
        }

        public Builder truncation(boolean enabled) {
            this.truncation = enabled;
            return this;
        }

        public Builder truncateFirstOnly() {
            this.truncateFirstOnly = true;
            return this;
        }

        public Builder truncateSecondOnly() {
            this.truncateSecondOnly = true;
            return this;
        }

        public Builder padding(boolean enabled) {
            this.padding = enabled;
            return this;
        }

        public Builder padToMaxLength() {
            this.padToMaxLength = true;
            return this;
        }

        public Builder maxLength(int length) {
            this.maxLength = length;
            return this;
        }

        public Builder padToMultipleOf(int num) {
            this.padToMultipleOf = num;
            return this;
        }

        public Builder stride(int stride) {
            this.stride = stride;
            return this;
        }

        public HuggingFaceTokenizerOptions build() {
            return new HuggingFaceTokenizerOptions(this);
        }
    }
}

