/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding.huggingface;

import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.vespa.embedding.huggingface.Encoding;
import ai.vespa.embedding.huggingface.HuggingFaceTokenizerOptions;
import java.io.IOException;
import java.nio.file.Path;

public class HuggingFaceTokenizer
implements AutoCloseable {
    private final ai.djl.huggingface.tokenizers.HuggingFaceTokenizer instance;

    public HuggingFaceTokenizer(Path path) throws IOException {
        this(path, HuggingFaceTokenizerOptions.defaults());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HuggingFaceTokenizer(Path path, HuggingFaceTokenizerOptions opts) throws IOException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HuggingFaceTokenizer.class.getClassLoader());
        try {
            this.instance = HuggingFaceTokenizer.createInstance(path, opts);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public Encoding encode(String text) {
        return Encoding.from(this.instance.encode(text));
    }

    @Override
    public void close() {
        this.instance.close();
    }

    private static ai.djl.huggingface.tokenizers.HuggingFaceTokenizer createInstance(Path path, HuggingFaceTokenizerOptions opts) throws IOException {
        HuggingFaceTokenizer.Builder builder = ai.djl.huggingface.tokenizers.HuggingFaceTokenizer.builder().optTokenizerPath(path);
        opts.addSpecialToken().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optAddSpecialTokens(arg_0));
        opts.truncation().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optTruncation(arg_0));
        if (opts.truncateFirstOnly()) {
            builder.optTruncateFirstOnly();
        }
        if (opts.truncateSecondOnly()) {
            builder.optTruncateSecondOnly();
        }
        opts.padding().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optPadding(arg_0));
        if (opts.padToMaxLength()) {
            builder.optPadToMaxLength();
        }
        opts.maxLength().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optMaxLength(arg_0));
        opts.padToMultipleOf().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optPadToMultipleOf(arg_0));
        opts.stride().ifPresent(arg_0 -> ((HuggingFaceTokenizer.Builder)builder).optStride(arg_0));
        return builder.build();
    }
}

