/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding.huggingface;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public record Encoding(List<Long> ids, List<Long> typeIds, List<String> tokens, List<Long> wordIds, List<Long> attentionMask, List<Long> specialTokenMask, List<CharSpan> charTokenSpans, List<Encoding> overflowing) {
    public Encoding {
        ids = List.copyOf(ids);
        typeIds = List.copyOf(typeIds);
        tokens = List.copyOf(tokens);
        wordIds = List.copyOf(wordIds);
        attentionMask = List.copyOf(attentionMask);
        specialTokenMask = List.copyOf(specialTokenMask);
        charTokenSpans = List.copyOf(charTokenSpans);
        overflowing = List.copyOf(overflowing);
    }

    static Encoding from(ai.djl.huggingface.tokenizers.Encoding e) {
        return new Encoding(Encoding.toList(e.getIds()), Encoding.toList(e.getTypeIds()), List.of(e.getTokens()), Encoding.toList(e.getWordIds()), Encoding.toList(e.getAttentionMask()), Encoding.toList(e.getSpecialTokenMask()), Arrays.stream(e.getCharTokenSpans()).map(CharSpan::from).toList(), Arrays.stream(e.getOverflowing()).map(Encoding::from).toList());
    }

    private static List<Long> toList(long[] array) {
        if (array == null) {
            return List.of();
        }
        ArrayList<Long> list = new ArrayList<Long>(array.length);
        for (long e : array) {
            list.add(e);
        }
        return list;
    }

    public record CharSpan(int start, int end) {
        public static final CharSpan NONE = new CharSpan(-1, -1);

        static CharSpan from(ai.djl.huggingface.tokenizers.jni.CharSpan s) {
            if (s == null) {
                return NONE;
            }
            return new CharSpan(s.getStart(), s.getEnd());
        }

        public boolean isNone() {
            return this.equals(NONE);
        }
    }
}

