/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.modelintegration.evaluator;

import ai.vespa.modelintegration.evaluator.OnnxEvaluator;
import ai.vespa.modelintegration.evaluator.OnnxEvaluatorOptions;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.SharedResource;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class OnnxEvaluatorCache {
    private final Object monitor = new Object();
    private final Map<Id, SharedEvaluator> cache = new HashMap<Id, SharedEvaluator>();
    private final OnnxEvaluatorFactory factory;

    @Inject
    public OnnxEvaluatorCache() {
        this(OnnxEvaluator::new);
    }

    OnnxEvaluatorCache(OnnxEvaluatorFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEvaluator evaluatorOf(String modelPath, OnnxEvaluatorOptions options) {
        Object object = this.monitor;
        synchronized (object) {
            ResourceReference reference;
            Id id = new Id(modelPath, options);
            SharedEvaluator sharedInstance = this.cache.get(id);
            if (sharedInstance == null) {
                return this.newInstance(id);
            }
            try {
                reference = sharedInstance.refer(id);
            }
            catch (IllegalStateException e) {
                return this.newInstance(id);
            }
            return new ReferencedEvaluator(sharedInstance, reference);
        }
    }

    int size() {
        return this.cache.size();
    }

    private ReferencedEvaluator newInstance(Id id) {
        SharedEvaluator evaluator = new SharedEvaluator(id, this.factory.create(id.modelPath, id.options));
        this.cache.put(id, evaluator);
        ReferencedEvaluator referenced = new ReferencedEvaluator(evaluator, evaluator.refer(id));
        evaluator.release();
        return referenced;
    }

    @FunctionalInterface
    static interface OnnxEvaluatorFactory {
        public OnnxEvaluator create(String var1, OnnxEvaluatorOptions var2);
    }

    record Id(String modelPath, OnnxEvaluatorOptions options) {
    }

    public class SharedEvaluator
    extends AbstractResource {
        private final Id id;
        private final OnnxEvaluator instance;

        private SharedEvaluator(Id id, OnnxEvaluator instance) {
            this.id = id;
            this.instance = instance;
        }

        public OnnxEvaluator instance() {
            return this.instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            OnnxEvaluatorCache onnxEvaluatorCache = OnnxEvaluatorCache.this;
            synchronized (onnxEvaluatorCache) {
                OnnxEvaluatorCache.this.cache.remove(this.id);
            }
            this.instance.close();
        }
    }

    public class ReferencedEvaluator
    extends ReferencedResource<SharedEvaluator> {
        ReferencedEvaluator(SharedEvaluator resource, ResourceReference reference) {
            super((SharedResource)resource, reference);
        }

        public OnnxEvaluator evaluator() {
            return ((SharedEvaluator)this.getResource()).instance();
        }
    }
}

