/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import com.yahoo.collections.ListMap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NamingConstraintSolver {
    private final ListMap<String, Integer> possibleAssignments;
    private final ListMap<DimensionRenamer.Arc, DimensionRenamer.Constraint> constraints;
    private int iterations = 0;
    private final int maxIterations;

    private NamingConstraintSolver(Set<String> dimensions, ListMap<DimensionRenamer.Arc, DimensionRenamer.Constraint> constraints, int maxIterations) {
        this.possibleAssignments = NamingConstraintSolver.allPossibilities(dimensions);
        this.constraints = constraints;
        this.maxIterations = maxIterations;
    }

    private static ListMap<String, Integer> allPossibilities(Set<String> dimensions) {
        ListMap all = new ListMap();
        for (String dimension : dimensions) {
            for (int i = 0; i < Math.min(dimensions.size(), 20); ++i) {
                all.put((Object)dimension, (Object)i);
            }
        }
        return all;
    }

    private Map<String, Integer> trySolve() {
        HashMap<String, Integer> solution = new HashMap<String, Integer>();
        for (String dimension : this.possibleAssignments.keySet()) {
            List values = this.possibleAssignments.get((Object)dimension);
            if (values.size() > 1) {
                if (!this.ac3()) {
                    return null;
                }
                values.sort(Integer::compare);
                this.possibleAssignments.replace((Object)dimension, (Object)((Integer)values.get(0)));
            }
            solution.put(dimension, (Integer)this.possibleAssignments.get((Object)dimension).get(0));
            if (this.iterations <= this.maxIterations) continue;
            return null;
        }
        return solution;
    }

    private boolean ac3() {
        ArrayDeque<DimensionRenamer.Arc> workList = new ArrayDeque<DimensionRenamer.Arc>(this.constraints.keySet());
        while (!workList.isEmpty()) {
            DimensionRenamer.Arc arc = (DimensionRenamer.Arc)workList.pop();
            ++this.iterations;
            if (this.revise(arc)) {
                if (this.possibleAssignments.get((Object)arc.from).isEmpty()) {
                    return false;
                }
                for (DimensionRenamer.Arc constraint : this.constraints.keySet()) {
                    if (!arc.from.equals(constraint.to) || arc.to.equals(constraint.from)) continue;
                    workList.add(constraint);
                }
            }
            if (this.iterations <= this.maxIterations) continue;
            return false;
        }
        return true;
    }

    private boolean revise(DimensionRenamer.Arc arc) {
        boolean revised = false;
        Iterator fromIterator = this.possibleAssignments.get((Object)arc.from).iterator();
        while (fromIterator.hasNext()) {
            Integer from = (Integer)fromIterator.next();
            boolean satisfied = false;
            for (Integer to : this.possibleAssignments.get((Object)arc.to)) {
                if (!this.constraints.get((Object)arc).stream().allMatch(constraint -> constraint.test(from, to))) continue;
                satisfied = true;
            }
            if (satisfied) continue;
            fromIterator.remove();
            revised = true;
        }
        return revised;
    }

    public static Map<String, Integer> solve(Set<String> dimensions, ListMap<DimensionRenamer.Arc, DimensionRenamer.Constraint> constraints, int maxIterations) {
        return new NamingConstraintSolver(dimensions, constraints, maxIterations).trySolve();
    }
}

