/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.ScalarFunction;
import com.yahoo.tensor.functions.Slice;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Reshape
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;

    public Reshape(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        ((IntermediateOperation)this.inputs.get((int)0)).exportAsRankingFunction = true;
        if (this.inputs.size() == 2) {
            return this.typeWithShapeAsInput();
        }
        if (this.inputs.size() == 1) {
            return this.typeWithShapeAsAttribute();
        }
        throw new IllegalArgumentException("Expected 2 or 3 inputs for '" + this.name + "', got " + this.inputs.size());
    }

    private OrderedTensorType typeWithShapeAsInput() {
        int i;
        IntermediateOperation newShape = (IntermediateOperation)this.inputs.get(1);
        if (newShape.getConstantValue().isEmpty()) {
            throw new IllegalArgumentException("Reshape " + this.name + ": Shape input must be a constant.");
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        Tensor shape = newShape.getConstantValue().get().asTensor();
        ArrayList<Integer> dimSizes = new ArrayList<Integer>(shape.type().rank());
        shape.valueIterator().forEachRemaining(v -> dimSizes.add(v.intValue()));
        for (i = 0; i < dimSizes.size(); ++i) {
            if ((Integer)dimSizes.get(i) != 0) continue;
            if (i >= inputType.dimensions().size()) {
                throw new IllegalArgumentException("Reshape " + this.name + ": 0 value for dimension not found in input");
            }
            dimSizes.set(i, ((Long)inputType.dimensions().get(i).size().get()).intValue());
        }
        for (i = 0; i < dimSizes.size(); ++i) {
            if ((Integer)dimSizes.get(i) >= 0) continue;
            int shapeSize = dimSizes.stream().reduce(1, (a, b) -> a * b);
            int tensorSize = OrderedTensorType.tensorSize(inputType.type()).intValue();
            dimSizes.set(i, -1 * tensorSize / (shapeSize == 0 ? -1 : shapeSize));
        }
        return this.buildOutputType(dimSizes);
    }

    private OrderedTensorType typeWithShapeAsAttribute() {
        if (this.attributeMap.getList("shape").isEmpty() || this.attributeMap.getList("shape").get().size() == 0) {
            throw new IllegalArgumentException("Reshape in " + this.name + ": Shape attribute is empty.");
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        List<Value> shape = this.attributeMap.getList("shape").get();
        ArrayList<Integer> dimSizes = new ArrayList<Integer>(shape.size());
        for (Value v : shape) {
            int size = (int)v.asDouble();
            if (size < 0) {
                int shapeSize = (int)shape.stream().mapToDouble(Value::asDouble).reduce(1.0, (a, b) -> a * b);
                int tensorSize = OrderedTensorType.tensorSize(inputType.type()).intValue();
                size = -1 * shapeSize / tensorSize;
            }
            dimSizes.add(size);
        }
        return this.buildOutputType(dimSizes);
    }

    private OrderedTensorType buildOutputType(List<Integer> dimSizes) {
        OrderedTensorType.Builder outputTypeBuilder = new OrderedTensorType.Builder(this.resultValueType());
        for (int i = 0; i < dimSizes.size(); ++i) {
            outputTypeBuilder.add(TensorType.Dimension.indexed((String)String.format("%s_%d", this.vespaName(), i), (long)dimSizes.get(i).intValue()));
        }
        return outputTypeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return null;
        }
        if (!this.inputs.stream().map(IntermediateOperation::function).allMatch(Optional::isPresent)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        TensorFunction inputFunction = ((IntermediateOperation)this.inputs.get(0)).function().get();
        return this.reshape(inputFunction, inputType, this.type);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        this.addConstraintsFrom(this.type, renamer);
    }

    @Override
    public Reshape withInputs(List<IntermediateOperation> inputs) {
        return new Reshape(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    public TensorFunction reshape(TensorFunction inputFunction, OrderedTensorType inputType, OrderedTensorType outputType) {
        int dim;
        if (!OrderedTensorType.tensorSize(inputType.type()).equals(OrderedTensorType.tensorSize(outputType.type()))) {
            throw new IllegalArgumentException("New and old shape of tensor must have the same size when reshaping");
        }
        IntermediateOperation input = (IntermediateOperation)this.inputs.get(0);
        String inputFunctionName = input.rankingExpressionFunctionName();
        ArrayList<Slice.DimensionValue> dimensionValues = new ArrayList<Slice.DimensionValue>();
        EmbracedNode unrolled = new EmbracedNode(Reshape.unrollTensorExpression(outputType));
        long innerSize = 1L;
        for (dim = 0; dim < inputType.rank(); ++dim) {
            innerSize *= ((Long)inputType.dimensions().get(dim).size().get()).longValue();
        }
        for (dim = 0; dim < inputType.rank(); ++dim) {
            ConstantNode size;
            EmbracedNode inputDimensionExpression;
            String inputDimensionName = inputType.dimensions().get(dim).name();
            long inputDimensionSize = (Long)inputType.dimensions().get(dim).size().get();
            long previousInnerSize = innerSize;
            innerSize /= inputDimensionSize;
            if (inputDimensionSize == 1L) {
                inputDimensionExpression = new EmbracedNode((ExpressionNode)new ConstantNode((Value)DoubleValue.zero));
            } else if (dim == inputType.rank() - 1) {
                size = new ConstantNode((Value)new DoubleValue((double)inputDimensionSize));
                ArithmeticNode div = new ArithmeticNode((ExpressionNode)unrolled, ArithmeticOperator.MODULO, (ExpressionNode)size);
                inputDimensionExpression = new EmbracedNode((ExpressionNode)div);
            } else {
                size = new ConstantNode((Value)new DoubleValue((double)innerSize));
                ConstantNode previousSize = new ConstantNode((Value)new DoubleValue((double)previousInnerSize));
                ArithmeticNode mod = new ArithmeticNode((ExpressionNode)unrolled, ArithmeticOperator.MODULO, (ExpressionNode)previousSize);
                ArithmeticNode div = new ArithmeticNode((ExpressionNode)new EmbracedNode((ExpressionNode)mod), ArithmeticOperator.DIVIDE, (ExpressionNode)size);
                inputDimensionExpression = new EmbracedNode((ExpressionNode)div);
            }
            dimensionValues.add(new Slice.DimensionValue(Optional.of(inputDimensionName), TensorFunctionNode.wrapScalar((ExpressionNode)inputDimensionExpression)));
        }
        TensorFunctionNode.ExpressionTensorFunction inputIndices = new TensorFunctionNode.ExpressionTensorFunction((ExpressionNode)new ReferenceNode(inputFunctionName));
        Slice sliceIndices = new Slice((TensorFunction)inputIndices, dimensionValues);
        TensorFunctionNode sliceExpression = new TensorFunctionNode((TensorFunction)sliceIndices);
        return Generate.bound((TensorType)outputType.type(), (ScalarFunction)TensorFunctionNode.wrapScalar((ExpressionNode)sliceExpression));
    }

    private static ExpressionNode unrollTensorExpression(OrderedTensorType type) {
        if (type.rank() == 0) {
            return new ConstantNode((Value)DoubleValue.zero);
        }
        ArrayList<Object> children = new ArrayList<Object>();
        ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>();
        int size = 1;
        for (int i = type.dimensions().size() - 1; i >= 0; --i) {
            TensorType.Dimension dimension = type.dimensions().get(i);
            children.add(0, new ReferenceNode(dimension.name()));
            if (size > 1) {
                operators.add(0, ArithmeticOperator.MULTIPLY);
                children.add(0, new ConstantNode((Value)new DoubleValue((double)size)));
            }
            size = (int)((long)size * OrderedTensorType.dimensionSize(dimension));
            if (i <= 0) continue;
            operators.add(0, ArithmeticOperator.PLUS);
        }
        return new ArithmeticNode(children, operators);
    }

    @Override
    public String operationName() {
        return "Reshape";
    }
}

