/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.tensorflow;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.onnx.OnnxImporter;
import ai.vespa.rankingexpression.importer.tensorflow.GraphImporter;
import com.yahoo.collections.Pair;
import com.yahoo.io.IOUtils;
import com.yahoo.system.ProcessExecuter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import org.tensorflow.SavedModelBundle;

public class TensorFlowImporter
extends ModelImporter {
    private static final Logger log = Logger.getLogger(TensorFlowImporter.class.getName());
    private static final int defaultOnnxOpset = 8;
    private final OnnxImporter onnxImporter = new OnnxImporter();

    @Override
    public boolean canImport(String modelPath) {
        File modelDir = new File(modelPath);
        if (!modelDir.isDirectory()) {
            return false;
        }
        for (File file : modelDir.listFiles()) {
            if (file.toString().endsWith(".pbtxt")) {
                return true;
            }
            if (!file.toString().endsWith(".pb")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ImportedModel importModel(String modelName, String modelDir) {
        ImportedModel importedModel;
        block9: {
            if (modelDir.contains("tf_2_onnx")) {
                return this.convertToOnnxAndImport(modelName, modelDir);
            }
            SavedModelBundle model = SavedModelBundle.load((String)modelDir, (String[])new String[]{"serve"});
            try {
                importedModel = this.importModel(modelName, modelDir, model);
                if (model == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (model != null) {
                        try {
                            model.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not import TensorFlow model from directory '" + modelDir + "'", e);
                }
            }
            model.close();
        }
        return importedModel;
    }

    public ImportedModel importModel(String modelName, String modelDir, SavedModelBundle model) {
        try {
            IntermediateGraph graph = GraphImporter.importGraph(modelName, model);
            return TensorFlowImporter.convertIntermediateGraphToModel(graph, modelDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import TensorFlow model '" + model + "'", e);
        }
    }

    private ImportedModel convertToOnnxAndImport(String modelName, String modelDir) {
        Path tempDir = null;
        try {
            log.info("Converting TensorFlow model '" + modelDir + "' to ONNX...");
            tempDir = Files.createTempDirectory("tf2onnx", new FileAttribute[0]);
            String convertedPath = tempDir.toString() + File.separatorChar + "converted.onnx";
            Pair<Integer, String> res = this.convertToOnnx(modelDir, convertedPath, 8);
            if ((Integer)res.getFirst() != 0) {
                throw new IllegalArgumentException("Conversion from TensorFlow to ONNX failed for '" + modelDir + "'. Reason: " + (String)res.getSecond());
            }
            ImportedModel importedModel = this.onnxImporter.importModel(modelName, convertedPath);
            return importedModel;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Conversion from TensorFlow to ONNX failed for '" + modelDir + "'");
        }
        finally {
            if (tempDir != null) {
                IOUtils.recursiveDeleteDir((File)tempDir.toFile());
            }
        }
    }

    private Pair<Integer, String> convertToOnnx(String savedModel, String output, int opset) throws IOException {
        ProcessExecuter executer = new ProcessExecuter();
        String job = "vespa-convert-tf2onnx --saved-model " + savedModel + " --output " + output + " --opset " + opset;
        return executer.exec(job);
    }
}

