/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Squeeze
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private List<String> squeezeDimensions;

    public Squeeze(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        this.squeezeDimensions = new ArrayList<String>();
        Optional<List<Value>> squeezeDimsAttr = this.attributeMap.getList("squeeze_dims");
        if (squeezeDimsAttr.isEmpty()) {
            squeezeDimsAttr = this.attributeMap.getList("axes");
        }
        this.squeezeDimensions = squeezeDimsAttr.isEmpty() ? inputType.type().dimensions().stream().filter(dim -> OrderedTensorType.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList()) : squeezeDimsAttr.get().stream().map(Value::asDouble).map(Double::intValue).map(i -> i < 0 ? inputType.type().dimensions().size() - i : i).map(i -> (TensorType.Dimension)inputType.type().dimensions().get((int)i)).filter(dim -> OrderedTensorType.dimensionSize(dim) == 1L).map(TensorType.Dimension::name).collect(Collectors.toList());
        return this.squeezeDimensions.isEmpty() ? inputType : this.reducedType(inputType);
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputFunctionsPresent(1)) {
            return null;
        }
        TensorFunction inputFunction = ((IntermediateOperation)this.inputs.get(0)).function().get();
        return new Reduce(inputFunction, Reduce.Aggregator.sum, this.squeezeDimensions);
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.squeezeDimensions.size());
        for (String name : this.squeezeDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (newName.isEmpty()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.squeezeDimensions = renamedDimensions;
    }

    @Override
    public Squeeze withInputs(List<IntermediateOperation> inputs) {
        return new Squeeze(this.modelName(), this.name(), inputs, this.attributeMap);
    }

    private OrderedTensorType reducedType(OrderedTensorType inputType) {
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.resultValueType());
        for (TensorType.Dimension dimension : inputType.type().dimensions()) {
            if (this.squeezeDimensions.contains(dimension.name())) continue;
            builder.add(dimension);
        }
        return builder.build();
    }

    @Override
    public String operationName() {
        return "Squeeze";
    }
}

