/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Concat;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public class ConcatV2
extends IntermediateOperation {
    private String concatDimensionName;
    private int concatDimensionIndex;

    public ConcatV2(String modelName, String nodeName, List<IntermediateOperation> inputs) {
        super(modelName, nodeName, inputs);
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return null;
        }
        IntermediateOperation concatDimOp = (IntermediateOperation)this.inputs.get(this.inputs.size() - 1);
        if (!concatDimOp.getConstantValue().isPresent()) {
            throw new IllegalArgumentException("ConcatV2 in " + this.name + ": concat dimension must be a constant.");
        }
        Tensor concatDimTensor = concatDimOp.getConstantValue().get().asTensor();
        if (concatDimTensor.type().rank() != 0) {
            throw new IllegalArgumentException("ConcatV2 in " + this.name + ": concat dimension must be a scalar.");
        }
        OrderedTensorType aType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        this.concatDimensionIndex = (int)concatDimTensor.asDouble();
        long concatDimSize = aType.dimensions().get(this.concatDimensionIndex).size().orElse(-1L);
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            OrderedTensorType bType = ((IntermediateOperation)this.inputs.get(i)).type().get();
            if (bType.rank() != aType.rank()) {
                throw new IllegalArgumentException("ConcatV2 in " + this.name + ": inputs must have save rank.");
            }
            for (int j = 0; j < aType.rank(); ++j) {
                long dimSizeA = aType.dimensions().get(j).size().orElse(-1L);
                long dimSizeB = bType.dimensions().get(j).size().orElse(-1L);
                if (j == this.concatDimensionIndex) {
                    concatDimSize += dimSizeB;
                    continue;
                }
                if (dimSizeA == dimSizeB) continue;
                throw new IllegalArgumentException("ConcatV2 in " + this.name + ": input dimension " + j + " differs in input tensors.");
            }
        }
        OrderedTensorType.Builder typeBuilder = new OrderedTensorType.Builder();
        int dimensionIndex = 0;
        for (TensorType.Dimension dimension : aType.dimensions()) {
            if (dimensionIndex == this.concatDimensionIndex) {
                this.concatDimensionName = dimension.name();
                typeBuilder.add(TensorType.Dimension.indexed((String)this.concatDimensionName, (long)concatDimSize));
            } else {
                typeBuilder.add(dimension);
            }
            ++dimensionIndex;
        }
        return typeBuilder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.inputs.stream().map(IntermediateOperation::function).allMatch(Optional::isPresent)) {
            return null;
        }
        TensorFunction result = ((IntermediateOperation)this.inputs.get(0)).function().get();
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            TensorFunction b = ((IntermediateOperation)this.inputs.get(i)).function().get();
            result = new Concat(result, b, this.concatDimensionName);
        }
        return result;
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.inputs.stream().map(IntermediateOperation::type).allMatch(Optional::isPresent)) {
            return;
        }
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        for (int i = 1; i < this.inputs.size() - 1; ++i) {
            OrderedTensorType b = ((IntermediateOperation)this.inputs.get(i)).type().get();
            String bDim = b.dimensions().get(this.concatDimensionIndex).name();
            String aDim = a.dimensions().get(this.concatDimensionIndex).name();
            renamer.addConstraint(aDim, bDim, DimensionRenamer::equals, this);
        }
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.concatDimensionName = renamer.dimensionNameOf(this.concatDimensionName).orElse(this.concatDimensionName);
    }
}

