/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleBinaryOperator;

public class Join
extends IntermediateOperation {
    private final DoubleBinaryOperator operator;

    public Join(String modelName, String nodeName, List<IntermediateOperation> inputs, DoubleBinaryOperator operator) {
        super(modelName, nodeName, inputs);
        this.operator = operator;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        OrderedTensorType a = this.largestInput().type().get();
        OrderedTensorType b = this.smallestInput().type().get();
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.resultValueType());
        int sizeDifference = a.rank() - b.rank();
        for (int i = 0; i < a.rank(); ++i) {
            TensorType.Dimension aDim = a.dimensions().get(i);
            long size = aDim.size().orElse(-1L);
            if (i - sizeDifference >= 0) {
                TensorType.Dimension bDim = b.dimensions().get(i - sizeDifference);
                size = Math.max(size, bDim.size().orElse(-1L));
            }
            if (aDim.type() == TensorType.Dimension.Type.indexedBound) {
                builder.add(TensorType.Dimension.indexed((String)aDim.name(), (long)size));
                continue;
            }
            if (aDim.type() == TensorType.Dimension.Type.indexedUnbound) {
                builder.add(TensorType.Dimension.indexed((String)aDim.name()));
                continue;
            }
            if (aDim.type() != TensorType.Dimension.Type.mapped) continue;
            builder.add(TensorType.Dimension.mapped((String)aDim.name()));
        }
        return builder.build();
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputTypesPresent(2)) {
            return null;
        }
        if (!this.allInputFunctionsPresent(2)) {
            return null;
        }
        IntermediateOperation a = this.largestInput();
        IntermediateOperation b = this.smallestInput();
        ArrayList<String> aDimensionsToReduce = new ArrayList<String>();
        ArrayList<String> bDimensionsToReduce = new ArrayList<String>();
        int sizeDifference = a.type().get().rank() - b.type().get().rank();
        for (int i = 0; i < b.type().get().rank(); ++i) {
            TensorType.Dimension bDim = b.type().get().dimensions().get(i);
            TensorType.Dimension aDim = a.type().get().dimensions().get(i + sizeDifference);
            long bSize = bDim.size().orElse(-1L);
            long aSize = aDim.size().orElse(-1L);
            if (bSize == 1L && aSize != 1L) {
                bDimensionsToReduce.add(bDim.name());
            }
            if (aSize != 1L || bSize == 1L) continue;
            aDimensionsToReduce.add(bDim.name());
        }
        TensorFunction aReducedFunction = a.function().get();
        if (aDimensionsToReduce.size() > 0) {
            aReducedFunction = new Reduce(a.function().get(), Reduce.Aggregator.sum, aDimensionsToReduce);
        }
        TensorFunction bReducedFunction = b.function().get();
        if (bDimensionsToReduce.size() > 0) {
            bReducedFunction = new Reduce(b.function().get(), Reduce.Aggregator.sum, bDimensionsToReduce);
        }
        return new com.yahoo.tensor.functions.Join(aReducedFunction, bReducedFunction, this.operator);
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        if (!this.allInputTypesPresent(2)) {
            return;
        }
        OrderedTensorType a = this.largestInput().type().get();
        OrderedTensorType b = this.smallestInput().type().get();
        int sizeDifference = a.rank() - b.rank();
        for (int i = 0; i < b.rank(); ++i) {
            String bDim = b.dimensions().get(i).name();
            String aDim = a.dimensions().get(i + sizeDifference).name();
            renamer.addConstraint(aDim, bDim, DimensionRenamer.Constraint.equal(false), this);
        }
    }

    private IntermediateOperation largestInput() {
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType b = ((IntermediateOperation)this.inputs.get(1)).type().get();
        return a.rank() >= b.rank() ? (IntermediateOperation)this.inputs.get(0) : (IntermediateOperation)this.inputs.get(1);
    }

    private IntermediateOperation smallestInput() {
        OrderedTensorType a = ((IntermediateOperation)this.inputs.get(0)).type().get();
        OrderedTensorType b = ((IntermediateOperation)this.inputs.get(1)).type().get();
        return a.rank() < b.rank() ? (IntermediateOperation)this.inputs.get(0) : (IntermediateOperation)this.inputs.get(1);
    }

    @Override
    public Join withInputs(List<IntermediateOperation> inputs) {
        return new Join(this.modelName(), this.name(), inputs, this.operator);
    }

    @Override
    public String operationName() {
        return "Join";
    }
}

