/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.onnx;

import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.StringValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import onnx.Onnx;

class AttributeConverter
implements IntermediateOperation.AttributeMap {
    private final Onnx.NodeProto node;

    private AttributeConverter(Onnx.NodeProto node) {
        this.node = node;
    }

    static AttributeConverter convert(Onnx.NodeProto node) {
        return new AttributeConverter(node);
    }

    @Override
    public Optional<Value> get(String name) {
        for (Onnx.AttributeProto attr : this.node.getAttributeList()) {
            if (!attr.getName().equals(name)) continue;
            switch (attr.getType()) {
                case INT: {
                    return Optional.of(DoubleValue.frozen((double)attr.getI()));
                }
                case FLOAT: {
                    return Optional.of(DoubleValue.frozen((double)attr.getF()));
                }
                case STRING: {
                    return Optional.of(StringValue.frozen((String)attr.getS().toString()));
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Optional<Value> get(String name, OrderedTensorType type) {
        return Optional.empty();
    }

    @Override
    public Optional<List<Value>> getList(String name) {
        for (Onnx.AttributeProto attr : this.node.getAttributeList()) {
            if (!attr.getName().equals(name)) continue;
            switch (attr.getType()) {
                case INTS: {
                    return Optional.of(attr.getIntsList().stream().map(DoubleValue::new).collect(Collectors.toList()));
                }
                case FLOATS: {
                    return Optional.of(attr.getFloatsList().stream().map(DoubleValue::new).collect(Collectors.toList()));
                }
                case STRINGS: {
                    return Optional.of(attr.getStringsList().stream().map(s -> StringValue.frozen((String)s.toString())).collect(Collectors.toList()));
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

