/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.operations;

import ai.vespa.rankingexpression.importer.DimensionRenamer;
import ai.vespa.rankingexpression.importer.OrderedTensorType;
import ai.vespa.rankingexpression.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class Reduce
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;
    private final Reduce.Aggregator aggregator;
    private List<String> reduceDimensions;

    public Reduce(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap, Reduce.Aggregator aggregator) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        this.aggregator = aggregator;
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        OrderedTensorType inputType = ((IntermediateOperation)this.inputs.get(0)).type().get();
        this.reduceDimensions = inputType.dimensionNames();
        if (this.attributeMap.getList("axes").isPresent()) {
            this.reduceDimensions = new ArrayList<String>();
            for (Value i : this.attributeMap.getList("axes").get()) {
                int dimensionIndex = (int)i.asDouble();
                if (dimensionIndex < 0) {
                    dimensionIndex = inputType.dimensions().size() - dimensionIndex;
                }
                this.reduceDimensions.add(inputType.dimensions().get(dimensionIndex).name());
            }
        }
        return this.reducedType(inputType, this.shouldKeepDimensions());
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        if (!this.allInputTypesPresent(1)) {
            return null;
        }
        TensorFunction inputFunction = ((IntermediateOperation)this.inputs.get(0)).function().get();
        com.yahoo.tensor.functions.Reduce output = new com.yahoo.tensor.functions.Reduce(inputFunction, this.aggregator, this.reduceDimensions);
        if (this.shouldKeepDimensions()) {
            TensorType.Builder typeBuilder = new TensorType.Builder(this.resultValueType());
            for (String name : this.reduceDimensions) {
                typeBuilder.indexed(name, 1L);
            }
            TensorType generatedType = typeBuilder.build();
            ConstantNode generatedExpression = new ConstantNode((Value)new DoubleValue(1.0));
            Generate generatedFunction = new Generate(generatedType, (Function)new GeneratorLambdaFunctionNode(generatedType, (ExpressionNode)generatedExpression).asLongListToDoubleOperator());
            output = new Join((TensorFunction)output, (TensorFunction)generatedFunction, ScalarFunctions.multiply());
        }
        return output;
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        ArrayList<String> renamedDimensions = new ArrayList<String>(this.reduceDimensions.size());
        for (String name : this.reduceDimensions) {
            Optional<String> newName = renamer.dimensionNameOf(name);
            if (newName.isEmpty()) {
                return;
            }
            renamedDimensions.add(newName.get());
        }
        this.reduceDimensions = renamedDimensions;
    }

    @Override
    public Reduce withInputs(List<IntermediateOperation> inputs) {
        return new Reduce(this.modelName(), this.name(), inputs, this.attributeMap, this.aggregator);
    }

    @Override
    public String operationName() {
        return "Reduce";
    }

    private boolean shouldKeepDimensions() {
        Optional<Value> keepDims = this.attributeMap.get("keepdims");
        return keepDims.isPresent() && keepDims.get().asBoolean();
    }

    private OrderedTensorType reducedType(OrderedTensorType inputType, boolean keepDimensions) {
        OrderedTensorType.Builder builder = new OrderedTensorType.Builder(this.resultValueType());
        for (TensorType.Dimension dimension : inputType.type().dimensions()) {
            if (!this.reduceDimensions.contains(dimension.name())) {
                builder.add(dimension);
                continue;
            }
            if (!keepDimensions) continue;
            builder.add(TensorType.Dimension.indexed((String)dimension.name(), (long)1L));
        }
        return builder.build();
    }
}

