/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.rankingexpression.importer.tensorflow;

import ai.vespa.rankingexpression.importer.ImportedModel;
import ai.vespa.rankingexpression.importer.IntermediateGraph;
import ai.vespa.rankingexpression.importer.ModelImporter;
import ai.vespa.rankingexpression.importer.tensorflow.GraphImporter;
import java.io.File;
import java.io.IOException;
import org.tensorflow.SavedModelBundle;

public class TensorFlowImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelDir = new File(modelPath);
        if (!modelDir.isDirectory()) {
            return false;
        }
        for (File file : modelDir.listFiles()) {
            if (file.toString().endsWith(".pbtxt")) {
                return true;
            }
            if (!file.toString().endsWith(".pb")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportedModel importModel(String modelName, String modelDir) {
        try (SavedModelBundle model = SavedModelBundle.load((String)modelDir, (String[])new String[]{"serve"});){
            ImportedModel importedModel = this.importModel(modelName, modelDir, model);
            return importedModel;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not import TensorFlow model from directory '" + modelDir + "'", e);
        }
    }

    public ImportedModel importModel(String modelName, String modelDir, SavedModelBundle model) {
        try {
            IntermediateGraph graph = GraphImporter.importGraph(modelName, model);
            return TensorFlowImporter.convertIntermediateGraphToModel(graph, modelDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import TensorFlow model '" + model + "'", e);
        }
    }
}

