/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.models.evaluation;

import ai.vespa.models.evaluation.BindingExtractor;
import ai.vespa.models.evaluation.Constant;
import ai.vespa.models.evaluation.FunctionReference;
import ai.vespa.models.evaluation.LazyValue;
import ai.vespa.models.evaluation.Model;
import ai.vespa.models.evaluation.OnnxModel;
import com.yahoo.lang.MutableInteger;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.stream.CustomCollectors;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LazyArrayContext
extends Context
implements ContextIndex {
    private final ExpressionFunction function;
    private final IndexedBindings indexedBindings;

    private LazyArrayContext(ExpressionFunction function, IndexedBindings indexedBindings) {
        this.function = function;
        this.indexedBindings = indexedBindings.copy(this);
    }

    LazyArrayContext(ExpressionFunction function, BindingExtractor bindingExtractor, Map<FunctionReference, ExpressionFunction> referencedFunctions, List<Constant> constants, Model model) {
        this.function = function;
        this.indexedBindings = new IndexedBindings(function, bindingExtractor, referencedFunctions, constants, this, model);
    }

    public void setMissingValue(Tensor value) {
        this.indexedBindings.setMissingValue(value);
    }

    public void put(String name, Value value) {
        this.put((int)this.requireIndexOf(name), value);
    }

    public final void put(int index, double value) {
        this.put(index, (Value)DoubleValue.frozen((double)value));
    }

    public void put(int index, Value value) {
        this.indexedBindings.set(index, value.freeze());
    }

    public TensorType getType(Reference reference) {
        return this.get(this.requireIndexOf(reference.toString())).type();
    }

    public Value get(String name) {
        return this.get(this.requireIndexOf(name));
    }

    public Value get(int index) {
        return this.indexedBindings.get(index);
    }

    public double getDouble(int index) {
        return this.get(index).asDouble();
    }

    public int getIndex(String name) {
        return this.requireIndexOf(name);
    }

    public String resolveBinding(String argument) {
        return null;
    }

    public int size() {
        return this.indexedBindings.names().size();
    }

    public Set<String> names() {
        return this.indexedBindings.names();
    }

    public Set<String> arguments() {
        return this.indexedBindings.arguments();
    }

    public Map<String, OnnxModel> onnxModels() {
        return this.indexedBindings.onnxModels();
    }

    private Integer requireIndexOf(String name) {
        Integer index = this.indexedBindings.indexOf(name);
        if (index == null) {
            throw new IllegalArgumentException("Value '" + name + "' can not be bound in " + String.valueOf((Object)this));
        }
        return index;
    }

    boolean isMissing(String name) {
        return this.indexedBindings.indexOf(name) == null;
    }

    public Value defaultValue() {
        return this.indexedBindings.missingValue;
    }

    LazyArrayContext copy() {
        return new LazyArrayContext(this.function, this.indexedBindings);
    }

    private static class IndexedBindings {
        private final Map<String, Integer> nameToIndex;
        private final Set<String> arguments;
        private final Value[] values;
        private final Map<String, OnnxModel> onnxModels;
        private static final Value missing = new DoubleValue(Double.NaN).freeze();
        private Value missingValue = new DoubleValue(Double.NaN).freeze();

        private IndexedBindings(Map<String, Integer> nameToIndex, Value[] values, Set<String> arguments, Map<String, OnnxModel> onnxModels) {
            this.nameToIndex = Map.copyOf(nameToIndex);
            this.values = values;
            this.arguments = arguments;
            this.onnxModels = Map.copyOf(onnxModels);
        }

        IndexedBindings(ExpressionFunction function, BindingExtractor bindingExtractor, Map<FunctionReference, ExpressionFunction> referencedFunctions, List<Constant> constants, LazyArrayContext owner, Model model) {
            BindingExtractor.FunctionInfo functionInfo = bindingExtractor.extractFrom(function);
            Set<String> bindTargets = functionInfo.bindTargets;
            this.onnxModels = Map.copyOf(functionInfo.onnxModelsInUse);
            this.arguments = Set.copyOf(functionInfo.arguments);
            this.values = new Value[bindTargets.size()];
            Arrays.fill(this.values, missing);
            MutableInteger nextIndex = new MutableInteger(0);
            this.nameToIndex = Map.copyOf((Map)bindTargets.stream().collect(CustomCollectors.toLinkedMap(name -> name, name -> nextIndex.next())));
            for (Constant constant : constants) {
                String constantReference = "constant(" + constant.name() + ")";
                Integer index = this.nameToIndex.get(constantReference);
                if (index == null) continue;
                this.values[index.intValue()] = new TensorValue(constant.value());
            }
            for (FunctionReference referencedFunction : referencedFunctions.keySet()) {
                Integer index = this.nameToIndex.get(referencedFunction.serialForm());
                if (index == null) continue;
                this.values[index.intValue()] = new LazyValue(referencedFunction, owner, model);
            }
        }

        private void setMissingValue(Tensor value) {
            this.missingValue = new TensorValue(value).freeze();
        }

        Value get(int index) {
            Value value = this.values[index];
            return value == missing ? this.missingValue : value;
        }

        void set(int index, Value value) {
            this.values[index] = value;
        }

        Set<String> names() {
            return this.nameToIndex.keySet();
        }

        Set<String> arguments() {
            return this.arguments;
        }

        Integer indexOf(String name) {
            return this.nameToIndex.get(name);
        }

        Map<String, OnnxModel> onnxModels() {
            return this.onnxModels;
        }

        IndexedBindings copy(Context context) {
            Value[] valueCopy = new Value[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                valueCopy[i] = this.values[i] instanceof LazyValue ? ((LazyValue)this.values[i]).copyFor(context) : this.values[i];
            }
            return new IndexedBindings(this.nameToIndex, valueCopy, this.arguments, this.onnxModels);
        }
    }
}

